/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class Island
extends Region {
    public static final int WEST_BARREN_ROAD = 0;
    public static final int EAST_BARREN_ROAD = 1;
    public static final int WILHELM = 2;
    private static final int NONE = 0;
    private static final int GRASS = 1;
    private static final int TREES = 2;
    private static final int SAND = 3;
    private static final int WATER = 4;
    private static final int BRIDGE = 5;
    private static final int VILLAGE = 6;
    private ArrayList altCharArr;
    private Place currPlace;
    private Image grass;
    private Image trees;
    private Image sand;
    private Image water;
    private Image bridge;
    private Image village;
    private int[][] imageArr = new int[][]{{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 4, 4, 4, 3, 4, 4, 4, 3, 3, 3, 3, 3, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 3, 4, 4, 4, 3, 1, 1, 3, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 1, 2, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 6, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 3, 3, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 4, 4, 4, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 3, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 3, 3, 1, 1, 3, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 3, 1, 1, 1, 1, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 3, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 4, 4, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private Plot plot;
    private int entrance;

    public Island(Plot plot, int n) {
        this.plot = plot;
        this.entrance = n;
        JPanel jPanel = new JPanel();
        MediaTracker mediaTracker = new MediaTracker(jPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.grass = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/grass1.gif"));
        this.trees = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/trees1.gif"));
        this.sand = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/sand1.gif"));
        this.water = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/water1.gif"));
        this.bridge = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bridge1.gif"));
        this.village = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/village1.gif"));
        mediaTracker.addImage(this.grass, 0);
        mediaTracker.addImage(this.trees, 0);
        mediaTracker.addImage(this.sand, 0);
        mediaTracker.addImage(this.water, 0);
        mediaTracker.addImage(this.bridge, 0);
        mediaTracker.addImage(this.village, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entrance == 0) {
            this.X0 = -175;
            this.Y0 = -200;
        } else if (this.entrance == 1) {
            this.X0 = -225;
            this.Y0 = -200;
        } else if (this.entrance == 2) {
            this.X0 = -425;
            this.Y0 = -25;
        }
        this.createAltChars();
        this.currPlace = new House(this.plot, 0);
    }

    private void createAltChars() {
        this.altCharArr = new ArrayList();
    }

    public ArrayList getAltChars() {
        return this.altCharArr;
    }

    public Point getInitPos() {
        if (this.currPlace == null) {
            if (this.entrance == 0) {
                return new Point(500 + this.X0, 400 + this.Y0);
            }
            if (this.entrance == 1) {
                return new Point(550 + this.X0, 400 + this.Y0);
            }
            return new Point(750 + this.X0, 225 + this.Y0);
        }
        return this.currPlace.getInitPos();
    }

    public Populace getAltChars(World world) {
        if (this.currPlace != null) {
            return this.currPlace.getAltChars(world);
        }
        return new Populace(world);
    }

    public int paintBack(Graphics graphics, DispPanel dispPanel, int n, int n2) {
        if (this.currPlace != null) {
            return this.currPlace.paintBack(graphics, dispPanel, n, n2);
        }
        int n3 = 0;
        while (n3 < this.imageArr.length) {
            int n4 = n3 * 25 + this.Y0;
            int n5 = 0;
            while (n5 < this.imageArr[n3].length) {
                int n6 = n5 * 25 + this.X0 + n;
                if (n6 > -25 && n4 > -25 && n6 < 735 && n4 < 525) {
                    if (this.imageArr[n3][n5] == 1) {
                        graphics.drawImage(this.grass, n6, n4, dispPanel);
                    } else if (this.imageArr[n3][n5] == 2) {
                        graphics.drawImage(this.trees, n6, n4, dispPanel);
                    } else if (this.imageArr[n3][n5] == 3) {
                        graphics.drawImage(this.sand, n6, n4, dispPanel);
                    } else if (this.imageArr[n3][n5] == 4) {
                        graphics.drawImage(this.water, n6, n4, dispPanel);
                    } else if (this.imageArr[n3][n5] == 5) {
                        graphics.drawImage(this.bridge, n6, n4, dispPanel);
                    } else if (this.imageArr[n3][n5] == 6) {
                        graphics.drawImage(this.grass, n6, n4, dispPanel);
                        graphics.drawImage(this.village, n6, n4, dispPanel);
                    }
                }
                ++n5;
            }
            ++n3;
        }
        return 1;
    }

    public boolean isBackStatic() {
        if (this.currPlace != null) {
            return this.currPlace.isBackStatic();
        }
        return false;
    }

    public int isMoveOK(int n, int n2, int n3) {
        if (this.currPlace == null) {
            int n4 = (n2 - this.X0) / 25;
            int n5 = (n3 - this.Y0) / 25;
            if (n == 1) {
                --n4;
            } else if (n == 2) {
                --n5;
            } else if (n == 3) {
                ++n4;
            } else if (n == 4) {
                ++n5;
            }
            int n6 = 2;
            if (n5 < this.imageArr.length && n4 < this.imageArr[0].length && (this.imageArr[n5][n4] == 1 || this.imageArr[n5][n4] == 6 || this.imageArr[n5][n4] == 3 || this.imageArr[n5][n4] == 5)) {
                n6 = 1;
            }
            int n7 = 0;
            while (n7 < this.altCharArr.size() && n6 == 1) {
                Character character = (Character)this.altCharArr.get(n7);
                int n8 = character.getX();
                int n9 = character.getY();
                if (n4 == n8 && n5 == n9) {
                    n6 = 2;
                }
                ++n7;
            }
            return n6;
        }
        return this.currPlace.isMoveOK(n, n2, n3);
    }

    public int doMove(int n, int n2, int n3) {
        if (this.currPlace == null) {
            if (n == 1) {
                this.X0 += 25;
            } else if (n == 2) {
                this.Y0 += 25;
            } else if (n == 3) {
                this.X0 -= 25;
            } else if (n == 4) {
                this.Y0 -= 25;
            }
            return 0;
        }
        return this.currPlace.doMove(n, n2, n3);
    }

    public boolean doTransit(int n, int n2) {
        if (this.currPlace != null) {
            int n3 = this.currPlace.doTransit(n, n2);
            if (this.currPlace instanceof House) {
                if (n3 == 2) {
                    this.currPlace = new HouseBasement(this.plot, 0);
                } else if (n3 == 3) {
                    this.currPlace = new HomeVillage(this.plot, 0);
                }
            } else if (this.currPlace instanceof HouseBasement) {
                if (n3 == 1) {
                    this.currPlace = new House(this.plot, 2);
                }
            } else if (this.currPlace instanceof HomeVillage) {
                if (n3 == 1) {
                    this.currPlace = new House(this.plot, 1);
                } else if (n3 == 6) {
                    this.currPlace = new BarrenRoadMarket(this.plot, 0);
                }
            } else if (this.currPlace instanceof BarrenRoadMarket && n3 == 3) {
                this.currPlace = new HomeVillage(this.plot, 0);
            }
            return n3 == 0;
        }
        return false;
    }

    public int openDoor(Hero hero) {
        return 2;
    }

    public String useItem(Hero hero, int n) {
        return new String("Can't use that item.");
    }

    public Item getItem(Hero hero) {
        if (this.currPlace != null) {
            return this.currPlace.getItem(hero);
        }
        return null;
    }

    public int command(int n, Hero hero) {
        if (this.currPlace != null) {
            return this.currPlace.command(n, hero);
        }
        return 7;
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        return false;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

