/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JPanel;

class House
extends Place {
    public static final int BED = 0;
    public static final int FRONT_DOOR = 1;
    public static final int STAIRS = 2;
    private static final int NONE = 0;
    private static final int FLOOR = 1;
    private static final int WALL = 2;
    private static final int DOOR = 3;
    private static final int STAIR = 4;
    private static final int BED1 = 5;
    private static final int BED2 = 6;
    private Image floor;
    private Image wall;
    private Image door;
    private Image stair;
    private Image bed1;
    private Image bed2;
    private int[][] imageArr = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 2}, {2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2}, {2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2}, {2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 5, 6, 1, 1, 2, 1, 2, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2}};
    private Plot plot;
    private int entrance;

    public House(Plot plot, int n) {
        this.plot = plot;
        this.entrance = n;
        JPanel jPanel = new JPanel();
        MediaTracker mediaTracker = new MediaTracker(jPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor3.gif"));
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.door = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/door1.gif"));
        this.stair = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/stair1.gif"));
        this.bed1 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bed1a.gif"));
        this.bed2 = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bed1b.gif"));
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.door, 0);
        mediaTracker.addImage(this.stair, 0);
        mediaTracker.addImage(this.bed1, 0);
        mediaTracker.addImage(this.bed2, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.X0 = 200;
        this.Y0 = 100;
    }

    public Point getInitPos() {
        if (this.entrance == 0) {
            return new Point(25 + this.X0, 125 + this.Y0);
        }
        if (this.entrance == 1) {
            return new Point(150 + this.X0, 150 + this.Y0);
        }
        return new Point(250 + this.X0, 25 + this.Y0);
    }

    public Populace getAltChars(World world) {
        return new Populace(world);
    }

    public int paintBack(Graphics graphics, DispPanel dispPanel, int n, int n2) {
        int n3 = 0;
        while (n3 < this.imageArr.length) {
            int n4 = n3 * 25 + this.Y0;
            int n5 = 0;
            while (n5 < this.imageArr[n3].length) {
                int n6 = n5 * 25 + this.X0;
                if (this.imageArr[n3][n5] == 2) {
                    graphics.drawImage(this.wall, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 1) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 3) {
                    graphics.drawImage(this.door, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 4) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    graphics.drawImage(this.stair, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 5) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    graphics.drawImage(this.bed1, n6, n4, dispPanel);
                } else if (this.imageArr[n3][n5] == 6) {
                    graphics.drawImage(this.floor, n6, n4, dispPanel);
                    graphics.drawImage(this.bed2, n6, n4, dispPanel);
                }
                ++n5;
            }
            ++n3;
        }
        return 2;
    }

    public boolean isBackStatic() {
        return true;
    }

    public int isMoveOK(int n, int n2, int n3) {
        int n4 = (n2 - this.X0) / 25;
        int n5 = (n3 - this.Y0) / 25;
        if (n == 1) {
            --n4;
        } else if (n == 2) {
            --n5;
        } else if (n == 3) {
            ++n4;
        } else if (n == 4) {
            ++n5;
        }
        if (n5 < this.imageArr.length && n4 < this.imageArr[0].length && (this.imageArr[n5][n4] == 1 || this.imageArr[n5][n4] == 0 || this.imageArr[n5][n4] == 4)) {
            return 1;
        }
        return 2;
    }

    public int doMove(int n, int n2, int n3) {
        int n4 = (n3 - this.Y0) / 25;
        int n5 = (n2 - this.X0) / 25;
        if (this.imageArr[n4][n5] == 0) {
            return 4;
        }
        if (this.imageArr[n4][n5] == 4) {
            return 4;
        }
        return 0;
    }

    public int doTransit(int n, int n2) {
        int n3 = (n2 - this.Y0) / 25;
        int n4 = (n - this.X0) / 25;
        if (this.imageArr[n3][n4] == 0) {
            return 3;
        }
        if (this.imageArr[n3][n4] == 4) {
            return 2;
        }
        return 0;
    }

    public String useItem(Hero hero, int n) {
        return new String("Can't use that item.");
    }

    public Item getItem(Hero hero) {
        return null;
    }

    public int command(int n, Hero hero) {
        if (n == 4) {
            int n2 = (hero.getX() - this.X0) / 25;
            int n3 = (hero.getY() - this.Y0) / 25;
            if (n2 == 6 && n3 == 6 && hero.getDir() == 4) {
                this.imageArr[7][6] = 0;
                return 5;
            }
            if (n2 == 6 && n3 == 4 && hero.getDir() == 3) {
                this.imageArr[4][7] = 1;
                return 5;
            }
            return 7;
        }
        return 0;
    }
}

