/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class Game
implements KeyListener {
    static final String jarName = "rpg.jar";
    static final String imgJarName = "images.jar";
    static final String imgDir = "img/";
    static final String iconSmallLocation = "icon16.gif";
    static final String iconBigLocation = "icon32.gif";
    public static final String imgCharDir = "img/chars/";
    public static final String imgBackDir = "img/backs/";
    static final int winWidth = 710;
    static final int winHeight = 500;
    public static final int CMD_MOVE = 1;
    public static final int CMD_TALK = 2;
    public static final int CMD_ITEM = 3;
    public static final int CMD_DOOR = 4;
    public static final int CMD_STATUS = 5;
    public static final int IDLE = 1;
    public static final int INTRO = 2;
    public static final int MOVE = 3;
    public static final int TALK = 4;
    public static final int ITEM = 5;
    public static final int DOOR = 6;
    public static final int STATUS = 7;
    public static final int NO_DIR = 0;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int RIGHT = 3;
    public static final int DOWN = 4;
    public static final int STAT_DO_NOTHING = 0;
    public static final int STAT_GOOD_MOVE = 1;
    public static final int STAT_BAD_MOVE = 2;
    public static final int STAT_MOVE_TO_NEW_REGION = 3;
    public static final int STAT_MOVE_TO_NEW_PLACE = 4;
    public static final int STAT_CAN_OPEN_DOOR = 5;
    public static final int STAT_CANNOT_OPEN_DOOR = 6;
    public static final int STAT_NO_DOOR = 7;
    private static JFrame frame;
    private JLabel statusBar;
    private UserInterface ui;
    private IntroScreen introScreen;
    private Dialog dialog;
    private Painter painter;
    private StepThread stepClock;
    private World world;
    private Plot plot;
    private Hero hero;
    private Populace people;
    private int gameMode;
    private int mainStatus;
    private int dirOfHeroMove;

    public Game() {
        this.setMode(2);
        this.hero = null;
        this.people = null;
        this.mainStatus = 0;
    }

    public void init() {
        frame = new JFrame("RPG I");
        ((Component)frame).setSize(710, 500);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.addKeyListener(this);
        this.statusBar = new JLabel();
        DispPanel dispPanel = new DispPanel(frame, this.statusBar);
        ControlPanel controlPanel = new ControlPanel(frame, this.statusBar, this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.statusBar);
        frame.setJMenuBar(new RPGMenuBar(frame, this, this.statusBar, dispPanel, controlPanel));
        frame.getContentPane().add((Component)dispPanel, "North");
        frame.getContentPane().add((Component)controlPanel, "Center");
        frame.getContentPane().add((Component)jPanel, "South");
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        dispPanel.setBorder(border2);
        controlPanel.setBorder(border2);
        dispPanel.setPreferredSize(new Dimension(400, 400));
        jPanel.setPreferredSize(new Dimension(700, 20));
        jPanel.setLayout(new GridLayout(1, 1));
        JarResources jarResources = new JarResources(new File(jarName).getAbsolutePath());
        Image image = Toolkit.getDefaultToolkit().createImage(jarResources.getResource(iconSmallLocation));
        ((Frame)frame).setIconImage(image);
        ((Component)frame).setVisible(true);
        frame.setResizable(false);
        this.world = new World();
        this.dialog = new Dialog();
        this.painter = new Painter(frame, dispPanel, controlPanel, this, this.world, this.dialog);
        this.ui = new UserInterface(this, frame, this.statusBar);
        this.introScreen = new IntroScreen(frame, this.statusBar, this);
        this.stepClock = new StepThread(this, this.painter);
        this.stepClock.start();
        this.painter.setIntroScreen(this.introScreen);
        this.painter.doCompleteRepaint();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Game game = new Game();
        game.init();
    }

    public void setMode(int n) {
        int n2 = this.gameMode;
        this.gameMode = n;
        if (n == 6) {
            this.mainStatus = this.hero.doCommand(4, this.dirOfHeroMove, this.people);
            if (this.mainStatus == 0) {
                this.setMode(1);
            } else {
                if (this.mainStatus == 5) {
                    this.setMode(1);
                }
                this.painter.doRepaint();
            }
        } else if (n == 7 || n == 5) {
            this.activateDialog();
        } else if (n == 1 && (n2 == 7 || n2 == 5 || n2 == 6)) {
            this.deactivateDialog();
        }
    }

    public void setMode(int n, int n2) {
        this.gameMode = n;
        if (n == 3) {
            if (n2 == 37) {
                this.preMove(1);
            } else if (n2 == 38) {
                this.preMove(2);
            } else if (n2 == 40) {
                this.preMove(4);
            } else if (n2 == 39) {
                this.preMove(3);
            }
        }
    }

    public int getMode() {
        return this.gameMode;
    }

    public int getStatus() {
        return this.mainStatus;
    }

    public void sendKeyToIntro(int n) {
        boolean bl;
        if (this.introScreen != null && (bl = this.introScreen.handleKeyPress(n))) {
            this.painter.doRepaint();
        }
    }

    public void restart() {
        this.setMode(2);
        this.introScreen = new IntroScreen(frame, this.statusBar, this);
        this.painter.setIntroScreen(this.introScreen);
        this.painter.doCompleteRepaint();
    }

    public void continueQuest() {
        this.introScreen = null;
        this.setMode(1);
        this.painter.doCompleteRepaint();
        this.plot = new Plot();
        this.world.load(this.plot);
        this.hero = new Hero("hero1", "Habib Test", this.world);
        this.people = this.world.getAltChars();
        this.painter.init(this.hero);
        this.painter.init(this.people);
        this.stepClock.setPeople(this.people);
    }

    public void beginNewQuest(String string, int n) {
        this.introScreen = null;
        this.setMode(1);
        this.painter.doCompleteRepaint();
        this.plot = new Plot();
        this.world.load(this.plot);
        this.hero = new Hero("hero" + n, string, this.world);
        this.people = this.world.getAltChars();
        this.painter.init(this.hero);
        this.painter.init(this.people);
        this.stepClock.setPeople(this.people);
    }

    public boolean doMove() {
        this.mainStatus = this.hero.doCommand(1, this.dirOfHeroMove, this.people);
        if (this.mainStatus == 1 || this.mainStatus == 3 || this.mainStatus == 4) {
            if (!this.world.isBackStatic()) {
                this.people.fixPosition(this.dirOfHeroMove);
            }
            return true;
        }
        if (this.mainStatus == 2) {
            this.painter.doRepaint();
            return false;
        }
        return false;
    }

    public int getDirection() {
        return this.dirOfHeroMove;
    }

    public void preMove(int n) {
        this.dirOfHeroMove = n;
    }

    public void endMove() {
        if (this.mainStatus == 1 || this.mainStatus == 3 || this.mainStatus == 4) {
            // empty if block
        }
        if (this.mainStatus == 3 || this.mainStatus == 4) {
            int n = this.hero.getX();
            int n2 = this.hero.getY();
            boolean bl = this.world.doTransit(n, n2);
            this.hero.setInitPos();
            this.people = this.world.getAltChars();
            this.painter.init(this.people);
            this.stepClock.setPeople(this.people);
            this.painter.doCompleteRepaint();
        }
    }

    public boolean isHeroThere(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n == 1) {
            n4 -= 25;
        } else if (n == 2) {
            n5 -= 25;
        } else if (n == 3) {
            n4 += 25;
        } else if (n == 4) {
            n5 += 25;
        }
        return n4 == this.hero.getX() && n5 == this.hero.getY();
    }

    public void activateDialog() {
        if (this.getMode() == 5) {
            this.dialog.init();
        }
        this.painter.doRepaint();
    }

    public void deactivateDialog() {
        this.painter.doRepaint();
    }

    public void sendToDialog(int n) {
        if (this.dialog.handleItemKeyPress(n, this.hero)) {
            this.painter.doRepaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.ui.handleKeyPress(keyEvent.getKeyCode());
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.ui.handleKeyRelease(keyEvent.getKeyCode());
    }
}

