/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class Dialog {
    private int currItemIndex;
    private int itemTotal;
    private String itemString;
    private Land land;
    private int talkIndex;
    private int talkTotal;
    private boolean showingItems;
    private int itemIndex;
    private boolean showingYesNo;
    private int yesNoIndex;

    public Dialog(Land land) {
        this.land = land;
        this.currItemIndex = 0;
        this.itemString = new String("");
        this.talkIndex = 1;
        this.itemIndex = 1;
        this.showingYesNo = false;
        this.yesNoIndex = 1;
    }

    public void handleItemKeyPress(int n, Hero hero) {
        if (!(n == 37 && this.itemString.equals("") || n == 39 && this.itemString.equals(""))) {
            if (n == 38 && this.itemString.equals("")) {
                if (this.currItemIndex > 0) {
                    --this.currItemIndex;
                }
            } else if (n == 40 && this.itemString.equals("")) {
                if (this.currItemIndex < this.itemTotal) {
                    ++this.currItemIndex;
                }
            } else if (n == 10 && this.itemString.equals("")) {
                if (this.currItemIndex < this.itemTotal) {
                    this.itemString = this.land.useItem(this.currItemIndex);
                } else if (this.currItemIndex == this.itemTotal) {
                    // empty if block
                }
            }
        }
    }

    public void move(int n, Hero hero, Character character, Environment environment) {
        if (n == 37) {
            if (this.showingYesNo && this.yesNoIndex == 2) {
                this.yesNoIndex = 1;
            }
        } else if (n == 38) {
            if (this.showingItems && this.itemIndex > 1) {
                --this.itemIndex;
            }
        } else if (n == 39) {
            if (this.showingYesNo && this.yesNoIndex == 1) {
                this.yesNoIndex = 2;
            }
        } else if (n == 40) {
            if (this.showingItems && this.itemIndex < this.itemTotal - 1) {
                ++this.itemIndex;
            }
        } else if (n == 10) {
            environment.incDialog(character);
            if (this.showingYesNo && this.yesNoIndex == 1) {
                environment.doYesDialog(hero, this.itemIndex - 1);
            }
        } else if (n == 27) {
            environment.escDialog(character);
        }
    }

    public boolean showTalkDialog(Environment environment, Character character, Character character2, Graphics graphics) {
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRoundRect(100, 300, 525, 98, 10, 10);
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRoundRect(101, 301, 522, 95, 10, 10);
        graphics.setFont(new Font("Verdana", 0, 12));
        graphics.setColor(new Color(255, 255, 255));
        this.showStatusDialog((Hero)character, graphics);
        graphics.drawString(environment.getDialogString((Hero)character, character2, this.itemIndex - 1), 110, 320);
        if (environment.isShowItems(character2)) {
            this.showingItems = true;
            this.showItemDialog(character, graphics);
        } else {
            this.itemIndex = 1;
            this.showingItems = false;
        }
        if (environment.isQuestion((Hero)character, character2, this.itemIndex - 1)) {
            this.showingYesNo = true;
            graphics.drawString("Yes     No", 350, 390);
            if (this.yesNoIndex == 1) {
                graphics.drawString(">", 340, 390);
            } else {
                graphics.drawString(">", 380, 390);
            }
        } else {
            this.yesNoIndex = 1;
            this.showingYesNo = false;
        }
        boolean bl = environment.isMoreDialog(character2);
        if (bl) {
            graphics.drawString("<enter>", 550, 390);
            return false;
        }
        this.itemIndex = 1;
        this.yesNoIndex = 1;
        this.showingItems = false;
        this.showingYesNo = false;
        return true;
    }

    public void initItemDialog(Hero hero) {
        this.currItemIndex = 0;
        this.itemString = new String("");
    }

    public void showItemDialog(Character character, Graphics graphics) {
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRoundRect(500, 2, 203, 308, 10, 10);
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRoundRect(501, 3, 200, 305, 10, 10);
        graphics.setFont(new Font("Verdana", 0, 12));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString("ITEMS", 510, 22);
        int n = 0;
        String string = ((Hero)character).getItem(n);
        while (string != null) {
            graphics.drawString(string, 520, 22 + (n + 1) * 20);
            if (n == this.currItemIndex) {
                graphics.drawString(">", 510, 22 + (n + 1) * 20);
            }
            string = ((Hero)character).getItem(++n);
        }
        this.itemTotal = n;
        graphics.setFont(new Font("Verdana", 2, 12));
        graphics.drawString("-- pick up item --", 520, 22 + (this.itemTotal + 1) * 20);
        if (this.currItemIndex == this.itemTotal) {
            graphics.drawString(">", 510, 22 + (this.itemTotal + 1) * 20);
        }
        this.showStatusDialog((Hero)character, graphics);
        if (!this.itemString.equals("")) {
            graphics.setColor(new Color(0, 0, 0));
            graphics.fillRoundRect(100, 300, 525, 98, 10, 10);
            graphics.setColor(new Color(255, 255, 255));
            graphics.drawRoundRect(101, 301, 522, 95, 10, 10);
            graphics.setFont(new Font("Verdana", 0, 12));
            graphics.setColor(new Color(255, 255, 255));
            graphics.drawString(this.itemString, 110, 320);
        }
    }

    public void showStatusDialog(Hero hero, Graphics graphics) {
        int n = 25;
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRoundRect(2, 2, 203, 158, 10, 10);
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawRoundRect(3, 3, 200, 155, 10, 10);
        graphics.setFont(new Font("Verdana", 0, 12));
        graphics.setColor(new Color(255, 255, 255));
        graphics.drawString("STATUS", 15, 20);
        graphics.drawString("NAME: " + hero.getName(), n, 40);
        graphics.drawString("LEVEL: " + hero.getLevel(), n, 60);
        graphics.drawString("HP: " + hero.getHP() + " / " + hero.getMaxHP(), n, 80);
        graphics.drawString("MP: " + hero.getMP() + " / " + hero.getMaxMP(), n, 100);
        graphics.drawString("EXP: " + hero.getExp(), n, 120);
        graphics.drawString("GOLD: " + hero.getGold(), n, 140);
    }

    public void showDoorDialog(int n, Graphics graphics) {
        if (n == 2 || n == 3) {
            graphics.setColor(new Color(0, 0, 0));
            graphics.fillRoundRect(100, 300, 525, 98, 10, 10);
            graphics.setColor(new Color(255, 255, 255));
            graphics.drawRoundRect(101, 301, 522, 95, 10, 10);
            graphics.setFont(new Font("Verdana", 0, 12));
            graphics.setColor(new Color(255, 255, 255));
            if (n == 2) {
                graphics.drawString("There is no door there.", 110, 320);
            } else if (n == 3) {
                graphics.drawString("You need a specific key to open this door.", 110, 320);
            }
        }
    }
}

