/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class Island
extends Environment {
    public static final int WEST_BARREN_ROAD = 0;
    public static final int EAST_BARREN_ROAD = 1;
    public static final int WILHELM = 2;
    private static final int NONE = 0;
    private static final int GRASS = 1;
    private static final int TREES = 2;
    private static final int SAND = 3;
    private static final int WATER = 4;
    private static final int BRIDGE = 5;
    private static final int VILLAGE = 6;
    private ArrayList altCharArr;
    private Image grass;
    private Image trees;
    private Image sand;
    private Image water;
    private Image bridge;
    private Image village;
    private int[][] imageArr = new int[][]{{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 4, 4, 4, 3, 4, 4, 4, 3, 3, 3, 3, 3, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 3, 4, 4, 4, 3, 1, 1, 3, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 1, 2, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 6, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 3, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 3, 3, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 4, 4}, {4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 4, 4, 4, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 3, 4, 4, 4, 4, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 3, 3, 1, 1, 3, 1, 1, 1, 4, 4, 4, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 3, 1, 1, 1, 1, 4, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 3, 1, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 4, 3, 3, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 3, 4, 4, 4, 3, 1, 1, 1, 1, 1, 3, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 1, 1, 3, 4, 4, 4, 4, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}};
    private JPanel dispPanel;
    private Land land;
    private Plot plot;
    private int entrance;

    public Island(Land land, JPanel jPanel, Plot plot, int n) {
        this.land = land;
        this.dispPanel = jPanel;
        this.plot = plot;
        this.entrance = n;
        MediaTracker mediaTracker = new MediaTracker(this.dispPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.grass = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/grass1.gif"));
        this.trees = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/trees1.gif"));
        this.sand = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/sand1.gif"));
        this.water = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/water1.gif"));
        this.bridge = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/bridge1.gif"));
        this.village = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/village1.gif"));
        mediaTracker.addImage(this.grass, 0);
        mediaTracker.addImage(this.trees, 0);
        mediaTracker.addImage(this.sand, 0);
        mediaTracker.addImage(this.water, 0);
        mediaTracker.addImage(this.bridge, 0);
        mediaTracker.addImage(this.village, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entrance == 0) {
            this.X0 = -175;
            this.Y0 = -200;
        } else if (this.entrance == 1) {
            this.X0 = -225;
            this.Y0 = -200;
        } else if (this.entrance == 2) {
            this.X0 = -425;
            this.Y0 = -25;
        }
        this.createAltChars();
    }

    private void createAltChars() {
        this.altCharArr = new ArrayList();
    }

    public ArrayList getAltChars() {
        return this.altCharArr;
    }

    public Point getInitPos() {
        if (this.entrance == 0) {
            return new Point(20, 16);
        }
        if (this.entrance == 1) {
            return new Point(22, 16);
        }
        return new Point(30, 9);
    }

    public void drawBack(Graphics graphics) {
        int n;
        int n2 = this.land.getMoveStep();
        int n3 = 0;
        int n4 = 0;
        if (n2 != -1) {
            n = this.land.getMoveDir();
            if (n == 1) {
                n3 = -25 + (int)((double)n2 / 4.0 * 25.0);
            } else if (n == 2) {
                n4 = -25 + (int)((double)n2 / 4.0 * 25.0);
            } else if (n == 3) {
                n3 = 25 - (int)((double)n2 / 4.0 * 25.0);
            } else if (n == 4) {
                n4 = 25 - (int)((double)n2 / 4.0 * 25.0);
            }
        }
        n = 0;
        while (n < this.imageArr.length) {
            int n5 = 0;
            while (n5 < this.imageArr[n].length) {
                int n6 = n5 * 25 + this.X0 + n3;
                int n7 = n * 25 + this.Y0 + n4;
                if (n6 > -25 && n7 > -25 && n6 < 735 && n7 < 525) {
                    if (this.imageArr[n][n5] == 1) {
                        graphics.drawImage(this.grass, n6, n7, this.dispPanel);
                    } else if (this.imageArr[n][n5] == 2) {
                        graphics.drawImage(this.trees, n6, n7, this.dispPanel);
                    } else if (this.imageArr[n][n5] == 3) {
                        graphics.drawImage(this.sand, n6, n7, this.dispPanel);
                    } else if (this.imageArr[n][n5] == 4) {
                        graphics.drawImage(this.water, n6, n7, this.dispPanel);
                    } else if (this.imageArr[n][n5] == 5) {
                        graphics.drawImage(this.bridge, n6, n7, this.dispPanel);
                    } else if (this.imageArr[n][n5] == 6) {
                        graphics.drawImage(this.grass, n6, n7, this.dispPanel);
                        graphics.drawImage(this.village, n6, n7, this.dispPanel);
                    }
                }
                ++n5;
            }
            ++n;
        }
    }

    public boolean isBackStatic() {
        return false;
    }

    public boolean isMoveOK(int n, int n2, int n3, ArrayList arrayList, ArrayList arrayList2) {
        int n4;
        boolean bl = false;
        if (n2 < this.imageArr.length && n < this.imageArr[0].length && (this.imageArr[n2][n] == 1 || this.imageArr[n2][n] == 6 || this.imageArr[n2][n] == 3 || this.imageArr[n2][n] == 5)) {
            bl = true;
        }
        int n5 = 0;
        while (n5 < arrayList2.size() && bl) {
            Character character = (Character)arrayList2.get(n5);
            int n6 = character.getX();
            n4 = character.getY();
            if (n == n6 && n2 == n4) {
                bl = false;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < arrayList.size() && bl) {
            Character character = (Character)arrayList.get(n7);
            n4 = character.getX();
            int n8 = character.getY();
            if (n == n4 && n2 == n8) {
                bl = false;
            }
            ++n7;
        }
        return bl;
    }

    public void move(int n, int n2, int n3, int n4) {
        this.X0 -= n3 * 25;
        this.Y0 -= n4 * 25;
        if (this.imageArr[n2][n] == 6 && n == 21 && n2 == 16 && n3 > 0) {
            this.land.changeEnv(3, 1);
        } else if (this.imageArr[n2][n] == 6 && n == 21 && n2 == 16 && n3 < 0) {
            this.land.changeEnv(3, 2);
        } else if (this.imageArr[n2][n] == 6 && n == 30 && n2 == 9) {
            this.land.changeEnv(7, 0);
        }
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        return false;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

