/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPanel;

class BarrenRoadMarket
extends Environment {
    public static final int ENTRANCE = 0;
    private static final int NONE = 0;
    private static final int WALL = 1;
    private static final int FLOOR = 2;
    private static final int ARMOR = 3;
    private ArrayList altCharArr;
    private Image wall;
    private Image floor;
    private Image armor;
    private int[][] imageArr = new int[][]{{1, 1, 1, 1, 1, 1}, {1, 3, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 0}, {1, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 1}, {1, 1, 1, 1, 1, 1}};
    private JPanel dispPanel;
    private Land land;
    private Plot plot;
    private int entrance;

    public BarrenRoadMarket(Land land, JPanel jPanel, Plot plot, int n) {
        this.land = land;
        this.dispPanel = jPanel;
        this.plot = plot;
        this.entrance = n;
        MediaTracker mediaTracker = new MediaTracker(this.dispPanel);
        JarResources jarResources = new JarResources(new File("images.jar").getAbsolutePath());
        this.wall = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/wall2.gif"));
        this.floor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/floor5.gif"));
        this.armor = Toolkit.getDefaultToolkit().createImage(jarResources.getResource("img/backs/armor1.gif"));
        mediaTracker.addImage(this.wall, 0);
        mediaTracker.addImage(this.floor, 0);
        mediaTracker.addImage(this.armor, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entrance == 0) {
            this.X0 = 225;
            this.Y0 = 100;
        }
        this.createAltChars();
    }

    private void createAltChars() {
        this.altCharArr = new ArrayList();
        Character character = new Character(1, 2, "merch1", 6, this.dispPanel);
        character.setName("Eileen");
        character.setCanMove(false);
        this.altCharArr.add(character);
        character = new Character(1, 5, "merch1", 6, this.dispPanel);
        character.setName("Jack");
        character.setCanMove(false);
        this.altCharArr.add(character);
    }

    public ArrayList getAltChars() {
        return this.altCharArr;
    }

    public Point getInitPos() {
        return new Point(4, 4);
    }

    public void drawBack(Graphics graphics) {
        int n = 0;
        while (n < this.imageArr.length) {
            int n2 = n * 25 + this.Y0;
            int n3 = 0;
            while (n3 < this.imageArr[n].length) {
                int n4 = n3 * 25 + this.X0;
                if (this.imageArr[n][n3] == 1) {
                    graphics.drawImage(this.wall, n4, n2, this.dispPanel);
                } else if (this.imageArr[n][n3] == 2) {
                    graphics.drawImage(this.floor, n4, n2, this.dispPanel);
                } else if (this.imageArr[n][n3] == 3) {
                    graphics.drawImage(this.floor, n4, n2, this.dispPanel);
                    graphics.drawImage(this.armor, n4, n2, this.dispPanel);
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean isBackStatic() {
        return true;
    }

    public boolean isMoveOK(int n, int n2, int n3, ArrayList arrayList, ArrayList arrayList2) {
        int n4;
        boolean bl = false;
        if (n2 < this.imageArr.length && n < this.imageArr[0].length && (this.imageArr[n2][n] == 2 || this.imageArr[n2][n] == 0)) {
            bl = true;
        }
        int n5 = 0;
        while (n5 < arrayList2.size() && bl) {
            Character character = (Character)arrayList2.get(n5);
            int n6 = character.getX();
            n4 = character.getY();
            if (n == n6 && n2 == n4) {
                bl = false;
            }
            ++n5;
        }
        int n7 = 0;
        while (n7 < arrayList.size() && bl) {
            Character character = (Character)arrayList.get(n7);
            n4 = character.getX();
            int n8 = character.getY();
            if (n == n4 && n2 == n8) {
                bl = false;
            }
            ++n7;
        }
        return bl;
    }

    public void move(int n, int n2, int n3, int n4) {
        if (this.imageArr[n2][n] == 0) {
            this.land.changeEnv(3, 3);
        }
    }

    public boolean doKeyPress(int n, ArrayList arrayList, ArrayList arrayList2) {
        return false;
    }

    public boolean isShowItems(Character character) {
        return false;
    }

    public boolean isQuestion(Hero hero, Character character, int n) {
        return false;
    }

    public String getDialogString(Hero hero, Character character, int n) {
        if (character.getName() == "Eileen") {
            return "You should sell some of your pots in Wilhelm to get some money.";
        }
        if (character.getName() == "Jack") {
            return "I'd like to sell you something, but you're broke.";
        }
        return "No one is there.";
    }

    public void incDialog(Character character) {
    }

    public void escDialog(Character character) {
    }

    public boolean isMoreDialog(Character character) {
        return false;
    }

    public void doYesDialog(Hero hero, int n) {
    }
}

