/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

class Land {
    public static final String imgCharDir = "img/chars/";
    public static final String imgBackDir = "img/backs/";
    public static final int HOUSE = 1;
    public static final int HOUSE_BASEMENT = 2;
    public static final int HOME_VILLAGE = 3;
    public static final int WEST_BARREN_ROAD = 4;
    public static final int EAST_BARREN_ROAD = 5;
    public static final int BARREN_ROAD_MARKET = 6;
    public static final int WILHELM = 7;
    public static final int OUTSIDE_WILHELM = 8;
    public static final int LEFT = 1;
    public static final int UP = 2;
    public static final int RIGHT = 3;
    public static final int DOWN = 4;
    public static final int MAX_AREA_WIDTH = 28;
    public static final int MAX_AREA_HEIGHT = 16;
    public static final int BLOCK_SIZE = 25;
    public static final int NO_ONE_CAN_MOVE = 1;
    public static final int SOMEONE_MOVED = 2;
    public static final int NO_ONE_MOVED = 3;
    private JFrame frame;
    private JPanel dispPanel;
    private JLabel statusBar;
    private ArrayList mainCharArr;
    private ArrayList altCharArr;
    private Environment currEnv;
    private int newEnv;
    private int initLoc;
    private int moveStep;
    private int moveStep2;
    private int moveDir;
    private boolean talkDialogActive;
    private int talkDialogIndex;
    private boolean itemDialogActive;
    private boolean statusDialogActive;

    public Land(JFrame jFrame, JPanel jPanel, JLabel jLabel) {
        this.frame = jFrame;
        this.dispPanel = jPanel;
        this.statusBar = jLabel;
        this.init();
    }

    private void init() {
        this.currEnv = new House(this, this.dispPanel, 0);
        Point point = this.currEnv.getInitPos();
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        this.mainCharArr = new ArrayList();
        this.altCharArr = this.currEnv.getAltChars();
        this.moveStep = -1;
    }

    public void init(String string, int n) {
        this.currEnv = new House(this, this.dispPanel, 0);
        Point point = this.currEnv.getInitPos();
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        this.mainCharArr = new ArrayList();
        Hero hero = new Hero(n2, n3, "hero" + n, 1, this.dispPanel);
        hero.setName(string);
        this.mainCharArr.add(hero);
        this.altCharArr = this.currEnv.getAltChars();
    }

    public void changeEnv(int n, int n2) {
        this.newEnv = n;
        this.initLoc = n2;
        ((DispPanel)this.dispPanel).startChangeEnvTimer();
    }

    public void changeEnvNow() {
        if (this.newEnv == 3) {
            this.currEnv = new HomeVillage(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 2) {
            this.currEnv = new HouseBasement(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 1) {
            this.currEnv = new House(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 4 || this.newEnv == 5) {
            this.currEnv = new Island(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 6) {
            this.currEnv = new BarrenRoadMarket(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 7) {
            this.currEnv = new Wilhelm(this, this.dispPanel, this.initLoc);
        } else if (this.newEnv == 8) {
            this.currEnv = new Island(this, this.dispPanel, this.initLoc);
        }
        Point point = this.currEnv.getInitPos();
        Hero hero = (Hero)this.mainCharArr.get(0);
        hero.setLoc(point);
        hero.setCurrEnv(this.newEnv);
        this.altCharArr = this.currEnv.getAltChars();
    }

    public void restart() {
        this.init();
    }

    public void draw(Graphics graphics) {
        this.currEnv.drawBack(graphics);
        this.drawCharacters(graphics);
        if (this.talkDialogActive) {
            Character character = (Character)this.mainCharArr.get(0);
            Character character2 = (Character)this.altCharArr.get(this.talkDialogIndex);
            Dialog.showTalkDialog(character, character2, graphics);
        } else if (this.itemDialogActive) {
            Character character = (Character)this.mainCharArr.get(0);
            Dialog.showItemDialog(character, graphics);
        } else if (this.statusDialogActive) {
            Hero hero = (Hero)this.mainCharArr.get(0);
            Dialog.showStatusDialog(hero, graphics);
        }
        if (this.moveStep != -1) {
            ++this.moveStep;
            if (this.moveStep > 4) {
                this.moveStep = -1;
            }
        }
        if (this.moveStep2 != -1) {
            ++this.moveStep2;
            if (this.moveStep2 > 4) {
                this.moveStep2 = -1;
            }
        }
    }

    private void drawCharacters(Graphics graphics) {
        int n;
        int n2 = 0;
        while (n2 < this.mainCharArr.size()) {
            Character character = (Character)this.mainCharArr.get(n2);
            int n3 = character.getX() * 25 + this.currEnv.X0;
            n = character.getY() * 25 + this.currEnv.Y0;
            if (this.moveStep != -1 && this.currEnv.isBackStatic()) {
                if (this.moveDir == 1) {
                    n3 = n3 + 25 - (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 2) {
                    n = n + 25 - (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 3) {
                    n3 = n3 - 25 + (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 4) {
                    n = n - 25 + (int)((double)this.moveStep / 4.0 * 25.0);
                }
            }
            graphics.drawImage(character.getImage(), n3, n, this.dispPanel);
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.altCharArr.size()) {
            Character character = (Character)this.altCharArr.get(n4);
            n = character.getX() * 25 + this.currEnv.X0;
            int n5 = character.getY() * 25 + this.currEnv.Y0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (this.moveStep != -1 && !this.currEnv.isBackStatic()) {
                if (this.moveDir == 1) {
                    n6 = -25 + (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 2) {
                    n7 = -25 + (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 3) {
                    n6 = 25 - (int)((double)this.moveStep / 4.0 * 25.0);
                } else if (this.moveDir == 4) {
                    n7 = 25 - (int)((double)this.moveStep / 4.0 * 25.0);
                }
            }
            if (character.isMoving() && this.moveStep2 != -1 && !this.currEnv.isBackStatic()) {
                int n10 = character.getDir();
                if (n10 == 1) {
                    n8 = 25 - (int)((double)this.moveStep2 / 4.0 * 25.0);
                } else if (n10 == 2) {
                    n9 = 25 - (int)((double)this.moveStep2 / 4.0 * 25.0);
                } else if (n10 == 3) {
                    n8 = -25 + (int)((double)this.moveStep2 / 4.0 * 25.0);
                } else if (n10 == 4) {
                    n9 = -25 + (int)((double)this.moveStep2 / 4.0 * 25.0);
                }
            }
            n = n + n6 + n8;
            n5 = n5 + n7 + n9;
            graphics.drawImage(character.getImage(), n, n5, this.dispPanel);
            ++n4;
        }
    }

    public int moveAltChars() {
        if (this.altCharArr.size() == 0) {
            return 1;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.altCharArr.size()) {
            boolean bl2 = false;
            Character character = (Character)this.altCharArr.get(n2);
            if ((!this.talkDialogActive || this.talkDialogIndex != n2) && character.canMove()) {
                int n3 = character.getX();
                int n4 = character.getY();
                int n5 = (int)Math.floor(Math.random() * 5.0);
                if (n5 == 0) {
                    character.setDir(1);
                    if (this.currEnv.isMoveOK(n3 - 1, n4, character.getType(), this.mainCharArr, this.altCharArr)) {
                        character.setX(n3 - 1);
                        bl2 = true;
                    }
                } else if (n5 == 1) {
                    character.setDir(3);
                    if (this.currEnv.isMoveOK(n3 + 1, n4, character.getType(), this.mainCharArr, this.altCharArr)) {
                        character.setX(n3 + 1);
                        bl2 = true;
                    }
                } else if (n5 == 2) {
                    character.setDir(2);
                    if (this.currEnv.isMoveOK(n3, n4 - 1, character.getType(), this.mainCharArr, this.altCharArr)) {
                        character.setY(n4 - 1);
                        bl2 = true;
                    }
                } else if (n5 == 3) {
                    character.setDir(4);
                    if (this.currEnv.isMoveOK(n3, n4 + 1, character.getType(), this.mainCharArr, this.altCharArr)) {
                        character.setY(n4 + 1);
                        bl2 = true;
                    }
                }
                if (bl2) {
                    bl = true;
                    this.moveStep2 = 1;
                }
            } else if (!character.canMove()) {
                ++n;
            }
            character.setMoving(bl2);
            ++n2;
        }
        if (n == this.altCharArr.size()) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 3;
    }

    public boolean move(int n) {
        this.talkDialogActive = false;
        this.itemDialogActive = false;
        this.statusDialogActive = false;
        boolean bl = false;
        Hero hero = (Hero)this.mainCharArr.get(0);
        int n2 = hero.getX();
        int n3 = hero.getY();
        if (n == 1) {
            hero.setDir(1);
            if (this.currEnv.isMoveOK(n2 - 1, n3, hero.getType(), this.mainCharArr, this.altCharArr)) {
                hero.setX(n2 - 1);
                this.currEnv.move(n2 - 1, n3, -1, 0);
                bl = true;
                this.moveDir = 1;
            }
        } else if (n == 2) {
            hero.setDir(2);
            if (this.currEnv.isMoveOK(n2, n3 - 1, hero.getType(), this.mainCharArr, this.altCharArr)) {
                hero.setY(n3 - 1);
                this.currEnv.move(n2, n3 - 1, 0, -1);
                bl = true;
                this.moveDir = 2;
            }
        } else if (n == 3) {
            hero.setDir(3);
            if (this.currEnv.isMoveOK(n2 + 1, n3, hero.getType(), this.mainCharArr, this.altCharArr)) {
                hero.setX(n2 + 1);
                this.currEnv.move(n2 + 1, n3, 1, 0);
                bl = true;
                this.moveDir = 3;
            }
        } else if (n == 4) {
            hero.setDir(4);
            if (this.currEnv.isMoveOK(n2, n3 + 1, hero.getType(), this.mainCharArr, this.altCharArr)) {
                hero.setY(n3 + 1);
                this.currEnv.move(n2, n3 + 1, 0, 1);
                bl = true;
                this.moveDir = 4;
            }
        }
        this.moveStep = bl ? 1 : -1;
        return bl;
    }

    public int getMoveStep() {
        return this.moveStep;
    }

    public int getMoveDir() {
        return this.moveDir;
    }

    public boolean doKeyPress(int n) {
        this.talkDialogActive = false;
        this.itemDialogActive = false;
        this.statusDialogActive = false;
        this.moveStep = -1;
        if (n == 83) {
            this.statusDialogActive = true;
            return true;
        }
        if (n == 84) {
            Hero hero = (Hero)this.mainCharArr.get(0);
            int n2 = hero.getX();
            int n3 = hero.getY();
            this.talkDialogActive = false;
            int n4 = 0;
            while (n4 < this.altCharArr.size() && !this.talkDialogActive) {
                Character character = (Character)this.altCharArr.get(n4);
                int n5 = character.getX();
                int n6 = character.getY();
                if (n2 == n5 && (n3 - n6 == -1 && hero.getDir() == 4 || n3 - n6 == 1 && hero.getDir() == 2) || n3 == n6 && (n2 - n5 == -1 && hero.getDir() == 3 || n2 - n5 == 1 && hero.getDir() == 1)) {
                    this.talkDialogActive = true;
                    this.talkDialogIndex = n4;
                    if (hero.getDir() == 4) {
                        character.setDir(2);
                    } else if (hero.getDir() == 2) {
                        character.setDir(4);
                    } else if (hero.getDir() == 1) {
                        character.setDir(3);
                    } else if (hero.getDir() == 3) {
                        character.setDir(1);
                    }
                }
                ++n4;
            }
            return true;
        }
        if (n == 73) {
            this.itemDialogActive = true;
            return true;
        }
        if (n == 32) {
            return true;
        }
        return this.currEnv.doKeyPress(n, this.mainCharArr, this.altCharArr);
    }
}

