/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class DispPanel
extends JPanel {
    private JFrame frame;
    private JLabel statusBar;
    private ControlPanel ctrlPanel;
    private Land land;
    public static final int DELAY = 200;
    public static final int CHANGE_DELAY = 300;
    public static final int INCREMENTS = 4;
    public static final int DELAY2 = 3000;
    private static Timer envTimer;
    private static Timer stepTimer;
    private static Timer altTimer;
    private static Timer stepTimer2;
    private IntroScreen introScreen;
    private boolean introDone;
    private int incCount;
    private int incCount2;
    private boolean allowEnvChange;
    private boolean allowMovement;

    public DispPanel(JFrame jFrame, JLabel jLabel) {
        this.frame = jFrame;
        this.statusBar = jLabel;
        this.land = new Land(jFrame, this, jLabel);
        this.setBackground(new Color(0, 0, 0));
        envTimer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DispPanel.this.allowEnvChange) {
                    DispPanel.this.allowMovement = true;
                    envTimer.stop();
                } else {
                    DispPanel.this.land.changeEnvNow();
                    DispPanel.this.repaint();
                    DispPanel.this.allowEnvChange = false;
                }
            }
        });
        envTimer.setInitialDelay(300);
        altTimer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DispPanel.this.moveAltChars();
            }
        });
        stepTimer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ++DispPanel.this.incCount;
                if (DispPanel.this.incCount > 4) {
                    stepTimer.stop();
                    if (DispPanel.this.allowEnvChange) {
                        DispPanel.this.allowMovement = false;
                        envTimer.start();
                    }
                } else {
                    DispPanel.this.repaint();
                }
            }
        });
        stepTimer.setInitialDelay(0);
        stepTimer2 = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ++DispPanel.this.incCount2;
                if (DispPanel.this.incCount2 > 4) {
                    stepTimer2.stop();
                    DispPanel.this.incCount2 = 0;
                } else {
                    DispPanel.this.repaint();
                }
            }
        });
        stepTimer2.setInitialDelay(0);
        this.incCount = 5;
        this.incCount2 = 5;
        this.allowEnvChange = false;
        this.introDone = false;
        this.introScreen = new IntroScreen(jFrame, jLabel, this);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.introDone) {
            this.land.draw(graphics);
        } else {
            this.introScreen.draw(graphics);
        }
    }

    private void incrPaint() {
        stepTimer.restart();
    }

    private void incrPaint2() {
        stepTimer2.restart();
    }

    public boolean isGameOn() {
        return this.introDone;
    }

    public void restart() {
        this.introDone = false;
        this.introScreen = new IntroScreen(this.frame, this.statusBar, this);
        this.repaint();
        this.ctrlPanel.repaint();
    }

    public void startChangeEnvTimer() {
        this.allowEnvChange = true;
    }

    private void moveAltChars() {
        this.incCount2 = 0;
        int n = this.land.moveAltChars();
        if (n == 1) {
            altTimer.stop();
        } else if (n == 2) {
            this.incrPaint2();
        }
    }

    public void handleKeyPress(int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.introDone) {
            if (!this.allowMovement) {
                return;
            }
            if (this.incCount <= 4) {
                return;
            }
        } else {
            this.handleIntro(n);
            return;
        }
        this.incCount = 0;
        if (n == 37) {
            bl = this.land.move(1);
            bl2 = true;
        } else if (n == 38) {
            bl = this.land.move(2);
            bl2 = true;
        } else if (n == 39) {
            bl = this.land.move(3);
            bl2 = true;
        } else if (n == 40) {
            bl = this.land.move(4);
            bl2 = true;
        } else {
            bl2 = this.land.doKeyPress(n);
        }
        if (bl) {
            this.incrPaint();
        } else {
            this.incCount = 5;
            if (bl2) {
                this.repaint();
            }
        }
    }

    private void handleIntro(int n) {
        boolean bl = this.introScreen.handleKeyPress(n);
        if (bl) {
            this.repaint();
        }
    }

    public void continueQuest() {
        this.introDone = true;
        this.allowMovement = true;
        this.land.init("Test", 1);
        this.ctrlPanel.repaint();
    }

    public void beginNewQuest(String string, int n) {
        this.introDone = true;
        this.allowMovement = true;
        this.land.init(string, n);
        this.ctrlPanel.repaint();
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.ctrlPanel = controlPanel;
    }
}

