/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.util.ArrayList;
import qos.game.AbstractHand;
import qos.game.Card;
import qos.game.ComputerPlayer;
import qos.game.Deck;
import qos.game.DoubleDeck;
import qos.game.Hand;
import qos.game.Player;
import qos.game.TableHand;
import qos.game.WastePile;

public class QueenOfSpades {
    private DoubleDeck deck;
    private WastePile wastePile;
    private ComputerPlayer[] players;
    public static final int NUMBER_OF_CARDS_DEALT = 10;
    public static final int DEFAULT_POINTS_TO_WIN = 1000;
    private int pointsToWin;

    public QueenOfSpades(int n, int n2) {
        this.pointsToWin = n2 > 0 ? n2 : 1000;
        this.wastePile = new WastePile();
        this.deck = new DoubleDeck();
        this.players = new ComputerPlayer[n];
        this.deck.shuffle(888888L);
        int n3 = 0;
        while (n3 < n) {
            this.players[n3] = new ComputerPlayer("Computer Player " + n3);
            ++n3;
        }
    }

    public void setPlayer(int n, String string, boolean bl) {
        this.players[n] = new ComputerPlayer(string);
        this.players[n].setVisibility(bl);
    }

    public String getPlayerName(int n) {
        return this.players[n].getName();
    }

    public void setPlayerStatus(int n, String string) {
        this.players[n].setStatus(string);
    }

    public void dealCards(int n, int n2) {
        this.deck.cut(n);
        int n3 = 0;
        while (n3 < 10) {
            int n4 = n2 + 1;
            while (n4 < this.players.length) {
                try {
                    this.players[n4].addCardToHand(this.deck.dealACard());
                }
                catch (Deck.DeckExhausted deckExhausted) {
                    // empty catch block
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2 + 1) {
                try {
                    this.players[n5].addCardToHand(this.deck.dealACard());
                }
                catch (Deck.DeckExhausted deckExhausted) {
                    // empty catch block
                }
                ++n5;
            }
            ++n3;
        }
        try {
            this.wastePile.placeCardFaceupOnPile(this.deck.dealACard());
        }
        catch (Deck.DeckExhausted deckExhausted) {
            // empty catch block
        }
    }

    public Hand getPlayerHand(int n) {
        return this.players[n].getHand();
    }

    public Card getTopWastePileCard() {
        try {
            return this.wastePile.topCardOnPile();
        }
        catch (Exception exception) {
            return new Card();
        }
    }

    public String doComputerTurn(int n) {
        int n2 = this.players[n].getFirstMove(this.getTopWastePileCard());
        String string = n2 == 2 ? this.pickUpCardFromPlayingPile(n) : this.pickUpWastePile(n);
        int n3 = this.players[n].getCardIndexToDiscard();
        Card card = this.players[n].removeCardFromHand(n3);
        string = string + " and Discarding the " + card;
        this.wastePile.placeCardFaceupOnPile(card);
        this.setPlayerStatus(n, Player.IDLE);
        return string;
    }

    public String pickUpWastePile(int n) {
        int n2 = this.wastePile.moveCardsToHand(this.players[n].getHand());
        this.setPlayerStatus(n, Player.BUSY);
        String string = n2 == 1 ? new String("Picked up waste pile: " + n2 + " card") : new String("Picked up waste pile: " + n2 + " cards");
        return string;
    }

    public String pickUpCardFromPlayingPile(int n) {
        String string;
        try {
            Card card = this.deck.dealACard();
            this.players[n].addCardToHand(card);
            string = new String("Picked up " + card);
        }
        catch (Deck.DeckExhausted deckExhausted) {
            string = new String(deckExhausted.getMessage());
        }
        this.setPlayerStatus(n, Player.BUSY);
        return string;
    }

    public String putCardOnWastePile(int n, int n2) {
        Card card = this.players[n].removeCardFromHand(n2);
        String string = new String("Discarding the " + card);
        this.wastePile.placeCardFaceupOnPile(card);
        this.setPlayerStatus(n, Player.IDLE);
        return string;
    }

    public boolean addHandCardsToNewTableHand(int n, int[] nArray) {
        boolean bl;
        TableHand tableHand = new TableHand();
        Hand hand = this.players[n].getHand();
        int n2 = 0;
        while (n2 < nArray.length) {
            tableHand.addCard(hand.getCard(nArray[n2]));
            ++n2;
        }
        if (tableHand.isValid()) {
            bl = true;
            int n3 = this.players[n].makeNewTableHand();
            while (tableHand.getSize() != 0) {
                Card card = tableHand.getCard(0);
                hand.removeCard(card);
                this.players[n].addCardToTableHand(tableHand.removeCard(0), n3);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean addHandCardsToOldTableHand(int n, int[] nArray, int n2, int n3) {
        boolean bl;
        TableHand tableHand = new TableHand();
        TableHand tableHand2 = new TableHand();
        int n4 = 999;
        int n5 = 0;
        if (n3 == 0) {
            TableHand tableHand3 = this.players[n].getTableHand(n2);
            int n6 = 0;
            while (n6 < tableHand3.getSize()) {
                tableHand.addCard(tableHand3.getCard(n6));
                ++n6;
            }
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            if (nArray[n7] > n4) {
                ++n5;
            }
            tableHand.addCard(this.players[n].removeCardFromHand(nArray[n7] - n5));
            tableHand2.addCard(tableHand.getCard(tableHand.getSize() - 1));
            n4 = nArray[n7];
            ++n7;
        }
        if (n3 == 1) {
            TableHand tableHand4 = this.players[n].getTableHand(n2);
            int n8 = 0;
            while (n8 < tableHand4.getSize()) {
                tableHand.addCard(tableHand4.getCard(n8));
                ++n8;
            }
        }
        if (tableHand.isValid()) {
            bl = true;
            this.players[n].replaceTableHand(n2, tableHand);
        } else {
            bl = false;
            while (tableHand2.getSize() != 0) {
                this.players[n].addCardToHand(tableHand2.removeCard(0));
            }
        }
        return bl;
    }

    private void addHandCardsToOldTableHand(int n) {
    }

    public boolean handIsFinished() {
        boolean bl = false;
        int n = 0;
        while (n < this.players.length && !bl) {
            if (this.players[n].getNumOfCards() == 0) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean roundIsFinished() {
        boolean bl = false;
        int n = 0;
        while (n < this.players.length && !bl) {
            if (this.players[n].getPoints() >= this.pointsToWin) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public int[] getPlayerWithMostPoints() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = -1;
        int n2 = 0;
        while (n2 < this.players.length) {
            int n3 = this.players[n2].getPoints();
            if (n3 > n) {
                arrayList = new ArrayList();
                arrayList.add(new Integer(n2));
                n = n3;
            } else if (n3 == n) {
                arrayList.add(new Integer(n2));
            }
            ++n2;
        }
        int[] nArray = new int[arrayList.size()];
        if (arrayList.size() == 0) {
            nArray = new int[]{-1};
        } else {
            int n4 = 0;
            while (n4 < arrayList.size()) {
                nArray[n4] = (Integer)arrayList.get(n4);
                ++n4;
            }
        }
        return nArray;
    }

    public int[] calculateScores() {
        int[] nArray = new int[this.players.length];
        int n = 0;
        while (n < this.players.length) {
            int n2 = this.calculateTableScore(n);
            int n3 = this.calculateScore(this.players[n].getHand());
            this.players[n].addPoints(n2 - n3);
            nArray[n] = n2 - n3;
            ++n;
        }
        return nArray;
    }

    private int calculateScore(AbstractHand abstractHand) {
        int n = 0;
        int n2 = 0;
        while (n2 < abstractHand.getSize()) {
            n += abstractHand.getCard(n2).getPoints();
            ++n2;
        }
        return n;
    }

    private int calculateTableScore(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.players[n].getNumOfTableHands()) {
            n2 += this.calculateScore(this.players[n].getTableHand(n3));
            ++n3;
        }
        return n2;
    }

    public void startNewHand() {
        int n = 0;
        while (n < this.players.length) {
            this.players[n].clearHands();
            ++n;
        }
        this.wastePile = new WastePile();
        this.deck = new DoubleDeck();
        this.deck.shuffle(888888L);
    }
}

