/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import qos.game.Player;
import qos.game.QueenOfSpades;

public class QoSPlay {
    private static final int DEFAULT_CUT = 50;
    private static final int PLAYER1 = 0;
    public static final int GET_WASTE_PILE = 1;
    public static final int PICK_PLAYING_PILE = 2;
    public static final int PUT_CARDS_ON_TABLE = 3;
    public static final int PUT_CARD_ON_WASTE_PILE = 4;
    public static final int PRINT_GAME_STATE = 5;
    public static final int END_ROUND = 98;
    public static final int END_GAME = 99;
    public static final int CONTINUE = 1;
    private static QueenOfSpades game;

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            System.out.println("usage: java QoSPlay");
            System.exit(0);
        }
        QoSPlay qoSPlay = new QoSPlay();
        int n = qoSPlay.getNumberOfPlayers();
        game = new QueenOfSpades(n);
        qoSPlay.getUserNames();
        int n2 = qoSPlay.getFirstDealer(n);
        int n3 = (n2 + 1) % n;
        int n4 = 0;
        int n5 = 1;
        while (!(n4 != 0 && game.roundIsFinished() || n5 != 1)) {
            qoSPlay.dealCards(n2, n3);
            System.out.println("\n\n========================================\n            HAND " + (n4 + 1) + "\n========================================\n");
            game.printState();
            while (!game.handIsFinished() && n5 == 1) {
                int n6 = n3;
                while (n6 < n && !game.handIsFinished() && n5 == 1) {
                    System.out.println("\n\n------------------------------------\n          PLAYER " + (n6 + 1) + "\n------------------------------------\n");
                    game.setPlayerStatus(n6, Player.IDLE);
                    n5 = qoSPlay.doUserPlay(n6);
                    System.out.println("\n/////////STATUS//////////");
                    game.printState();
                    System.out.println("/////////////////////////");
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n3 && !game.handIsFinished() && n5 == 1) {
                    System.out.println("\n\n------------------------------------\n          PLAYER " + (n7 + 1) + "\n------------------------------------\n");
                    game.setPlayerStatus(n7, Player.IDLE);
                    n5 = qoSPlay.doUserPlay(n7);
                    System.out.println("/////////STATUS//////////");
                    game.printState();
                    System.out.println("/////////////////////////");
                    ++n7;
                }
            }
            if (n5 == 1) {
                game.calculateScores();
                game.printScores();
                ++n4;
            }
            if (game.roundIsFinished() || n5 != 1) continue;
            System.out.println("\nHit <return>");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                bufferedReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            game.restart();
            n2 = (n2 + 1) % n;
            n3 = (n2 + 1) % n;
        }
        if (n5 != 1) {
            System.out.println("\n\nFor some reason, you have chosen to " + n5);
        }
    }

    private int getNumberOfPlayers() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = new String();
        boolean bl = true;
        while (bl) {
            try {
                System.out.print("\nHow many players? ");
                string = bufferedReader.readLine();
                if (Integer.parseInt(string) <= 1) continue;
                bl = false;
            }
            catch (Exception exception) {
                System.out.println("Invalid input: " + exception);
            }
        }
        return Integer.parseInt(string);
    }

    private void getUserNames() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = new String();
        boolean bl = true;
        while (bl) {
            try {
                System.out.print("\nPlayer 1, what is your name? ");
                string = bufferedReader.readLine();
                bl = false;
            }
            catch (Exception exception) {
                System.out.println("Invalid input: " + exception);
            }
        }
        game.setPlayer(0, string, true);
    }

    private int getFirstDealer(int n) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = new String();
        boolean bl = true;
        while (bl) {
            try {
                System.out.println("\nWho is going to deal first?");
                int n2 = 0;
                while (n2 < n) {
                    System.out.println(n2 + "\t" + game.getPlayerName(n2));
                    ++n2;
                }
                System.out.print("\t\t (0-" + (n - 1) + ") > ");
                string = bufferedReader.readLine();
                if (Integer.parseInt(string) < 0 || Integer.parseInt(string) >= n) continue;
                bl = false;
            }
            catch (Exception exception) {
                System.out.println("Invalid input: " + exception);
            }
        }
        return Integer.parseInt(string);
    }

    private void dealCards(int n, int n2) {
        if (n2 == 0) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = new String();
            boolean bl = true;
            while (bl) {
                try {
                    System.out.print("\nEnter percent to cut deck for dealer: ");
                    string = bufferedReader.readLine();
                    if (Integer.parseInt(string) <= 1 && Integer.parseInt(string) >= 99) continue;
                    bl = false;
                }
                catch (Exception exception) {
                    System.out.println("Invalid input: " + exception);
                }
            }
            game.dealCards(Integer.parseInt(string), n);
        } else {
            game.dealCards(50, n);
        }
    }

    private int doUserPlay(int n) {
        int n2 = -1;
        if (n != 0) {
            System.out.println("\n" + game.getPlayerName(n) + " is taking turn. (0)");
            game.doComputerTurn(n);
            return 1;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (n2 != 4) {
            String string = new String();
            boolean bl = true;
            while (bl) {
                try {
                    System.out.println("\n" + game.getPlayerName(n) + ", what do you want to do?");
                    game.printPlayerOptions(n);
                    System.out.print("\t\t> ");
                    n2 = Integer.parseInt(bufferedReader.readLine());
                    if (!game.choiceIsOK(n, n2)) continue;
                    bl = false;
                }
                catch (Exception exception) {
                    System.out.println("Invalid input: " + exception);
                }
            }
            switch (n2) {
                case 1: {
                    game.pickUpWastePile(n);
                    game.printPlayerHand(n);
                    break;
                }
                case 2: {
                    game.pickUpCardFromPlayingPile(n);
                    game.printPlayerHand(n);
                    break;
                }
                case 3: {
                    game.putCardsOnTable(n);
                    break;
                }
                case 4: {
                    game.putCardOnWastePile(n);
                    break;
                }
                case 5: {
                    System.out.println("-------------------------");
                    game.printState();
                    System.out.println("-------------------------");
                    break;
                }
                case 98: {
                    return 98;
                }
                case 99: {
                    return 99;
                }
            }
        }
        return 1;
    }
}

