/*
 * Decompiled with CFR 0.152.
 */
package qos.game;

import java.util.ArrayList;
import qos.game.Card;
import qos.game.Hand;
import qos.game.TableHand;

public class Player {
    private Hand hand = new Hand();
    private int points = 0;
    private String name;
    private boolean visible;
    private ArrayList tableCards;
    private String status;
    public static final String IDLE = new String("IDLE");
    public static final String BUSY = new String("BUSY");

    public Player(String string) {
        this.name = new String(string);
        this.tableCards = new ArrayList();
        this.status = new String(IDLE);
    }

    public void clearHands() {
        this.hand = new Hand();
        this.tableCards = new ArrayList();
        this.status = new String(IDLE);
    }

    public Hand getHand() {
        return this.hand;
    }

    public String getName() {
        return new String(this.name);
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public void setVisibility(boolean bl) {
        this.visible = bl;
    }

    public int getPoints() {
        return this.points;
    }

    public void addPoints(int n) {
        this.points += n;
    }

    public void setStatus(String string) {
        this.status = new String(string);
    }

    public String getStatus() {
        return new String(this.status);
    }

    public void addCardToHand(Card card) {
        this.hand.addCard(card);
    }

    public Card removeCardFromHand(int n) {
        return this.hand.removeCard(n);
    }

    public void addCardToTableHand(Card card, int n) {
        try {
            ((TableHand)this.tableCards.get(n)).addCard(card);
        }
        catch (Exception exception) {
            System.out.println("\n" + exception);
        }
    }

    public int makeNewTableHand() {
        this.tableCards.add(new TableHand());
        return this.tableCards.size() - 1;
    }

    public void replaceTableHand(int n, TableHand tableHand) {
        this.tableCards.remove(n);
        this.tableCards.add(n, tableHand);
    }

    public int getNumOfTableHands() {
        return this.tableCards.size();
    }

    public TableHand getTableHand(int n) {
        return (TableHand)this.tableCards.get(n);
    }

    public int getNumOfCards() {
        return this.hand.getSize();
    }

    public Card replaceCardInTableHand(int n, int n2, Card card) {
        try {
            return ((TableHand)this.tableCards.get(n)).replaceCard(n2, card);
        }
        catch (Exception exception) {
            System.out.println("\n" + exception);
            return new Card();
        }
    }

    public void printHand() {
        if (this.visible) {
            int n = 0;
            while (n < this.hand.getSize()) {
                System.out.println("\t" + this.hand.getCard(n));
                ++n;
            }
        } else {
            System.out.println("\tHidden hand");
        }
    }

    public void printTableHand() {
        if (this.tableCards.size() == 0) {
            System.out.println("\tNo cards on table");
        }
        int n = 0;
        while (n < this.tableCards.size()) {
            TableHand tableHand = (TableHand)this.tableCards.get(n);
            System.out.println("\tTable Cards " + n);
            int n2 = 0;
            while (n2 < tableHand.getSize()) {
                System.out.println("\t\t" + tableHand.getCard(n2));
                ++n2;
            }
            ++n;
        }
    }
}

