/*
 * Decompiled with CFR 0.152.
 */
package qos.app;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import qos.app.ScoreTableModel;

class ScorePanel
extends JPanel {
    ScoreTableModel scoreTableModel;
    JScrollPane scrollPane = new JScrollPane();

    public ScorePanel() {
        this.setBackground(new Color(0, 120, 0));
        this.scoreTableModel = new ScoreTableModel();
        this.scoreTableModel.addRow();
        this.setupTable(5);
    }

    public void initialize(String[] stringArray, int n) {
        this.removeAll();
        this.scoreTableModel = new ScoreTableModel(stringArray, n);
        this.scoreTableModel.addRow();
        this.setupTable(n + 1);
    }

    private void setupTable(int n) {
        JTable jTable = new JTable(this.scoreTableModel);
        jTable.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        TableColumn tableColumn = null;
        int n2 = 0;
        while (n2 < n) {
            tableColumn = jTable.getColumnModel().getColumn(n2);
            if (n2 == 0) {
                tableColumn.setPreferredWidth(50);
            } else {
                tableColumn.setPreferredWidth(100);
            }
            ++n2;
        }
        this.add(this.scrollPane);
    }

    public void addPointsForHand(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.scoreTableModel.setValueAt(new Integer(nArray[n]), this.scoreTableModel.getRowCount() - 2, n + 1);
            ++n;
        }
        this.scoreTableModel.calculateTotalScores();
        this.scoreTableModel.addRow();
    }

    public int[] getTotalPoints() {
        int n = this.scoreTableModel.getColumnCount() - 1;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (Integer)this.scoreTableModel.getValueAt(this.scoreTableModel.getRowCount() - 1, n2 + 1);
            ++n2;
        }
        return nArray;
    }
}

