/*
 * Decompiled with CFR 0.152.
 */
package qos.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import qos.app.GUI_Card;
import qos.app.GUI_Hand;
import qos.app.GUI_Play;
import qos.app.JarEntryGetter;
import qos.app.MainPlayScrollPanel;
import qos.app.ScorePanel;
import qos.app.TableCardScrollPanel;
import qos.game.Card;
import qos.game.Hand;
import qos.game.Rank;
import qos.game.Suit;

class MainPlayPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    JButton moveButton;
    JButton addButton;
    JButton contButton;
    JLabel statusBar;
    JTabbedPane tabPane;
    private GUI_Play qosPlay;
    Timer timer = null;
    private final int NO_PILE = -1;
    private final int PLAY_PILE = 0;
    private final int WASTE_PILE = 1;
    private final int USER_PILE = 2;
    private final int COMP1_PILE = 3;
    private final int COMP2_PILE = 4;
    private final int COMP3_PILE = 5;
    public static final int USER_HAND = 0;
    public static final int COMP1_HAND = 1;
    public static final int COMP2_HAND = 2;
    public static final int COMP3_HAND = 3;
    private final int NO_CARD = -1;
    private int pileBeingDragged = -1;
    private int cardBeingDragged = -1;
    private final int WAIT = 1;
    private final int READY = 2;
    private final int BUSY = 3;
    private final int MOVE = 4;
    private int player1State = 1;
    private final int PILE1_X = 260;
    private final int PILE1_Y = 150;
    private final int PILE2_X = 350;
    private final int PILE2_Y = 150;
    private final int HAND0_X = 250;
    private final int HAND0_Y = 300;
    private final int HAND1_X = 10;
    private final int HAND1_Y = 80;
    private final int HAND2_X = 250;
    private final int HAND2_Y = 10;
    private final int HAND3_X = 600;
    private final int HAND3_Y = 80;
    private final int CARD_OFFSET = 15;
    private final int SLOW_SPEED = 1000;
    private Image CARD_BACK_IMAGE;
    private Image CARD_BACK_HORIZONTAL_IMAGE;
    private Image NO_CARD_IMAGE;
    private boolean gameInProgress;
    private boolean roundIsOver;
    private boolean gameIsOver;
    private int mx;
    private int my;
    private ArrayList hands;
    private ArrayList piles;
    private int bxLast;
    private int byLast;
    private int dealer;
    private int playerTurn;
    private int numberOfPlayers;
    private String[] playerNames;
    private boolean mouseClickDone = false;
    private String gameOverString;

    public MainPlayPanel(JTabbedPane jTabbedPane, JLabel jLabel) {
        this.setBackground(new Color(0, 120, 0));
        this.statusBar = jLabel;
        this.tabPane = jTabbedPane;
        this.gameInProgress = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.moveButton = new JButton("Move cards");
        this.moveButton.setVisible(false);
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPlayPanel.this.moveCards();
            }
        });
        this.add(this.moveButton);
        this.addButton = new JButton("Add cards");
        this.addButton.setVisible(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPlayPanel.this.addCards();
            }
        });
        this.add(this.addButton);
        this.contButton = new JButton("Start next round");
        this.contButton.setVisible(false);
        this.contButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPlayPanel.this.startNewHand();
            }
        });
        this.add(this.contButton);
        this.gameIsOver = false;
    }

    public void startNewGame(Frame frame, String[] stringArray, int n, int n2, int n3) {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.statusBar.setText(" ");
        this.playerNames = stringArray;
        this.numberOfPlayers = n;
        this.dealer = n2;
        this.gameIsOver = false;
        this.qosPlay = new GUI_Play(frame, stringArray, n, n2, n3);
        this.loadCardImages();
    }

    public void startNewHand() {
        this.contButton.setVisible(false);
        this.gameIsOver = false;
        int n = 0;
        while (n < this.numberOfPlayers) {
            TableCardScrollPanel tableCardScrollPanel = (TableCardScrollPanel)this.tabPane.getComponentAt(n + 1);
            tableCardScrollPanel.initialize();
            ++n;
        }
        this.qosPlay.startNewHand();
        this.loadCardImages();
        this.dealer = (this.dealer + 1) % this.numberOfPlayers;
        this.startPlay();
        this.repaint();
    }

    private void loadCardImages() {
        GUI_Card gUI_Card;
        Card card;
        GUI_Hand gUI_Hand;
        JarEntryGetter jarEntryGetter = new JarEntryGetter();
        this.hands = new ArrayList();
        MediaTracker mediaTracker = new MediaTracker(this);
        Object var7_3 = null;
        int n = 0;
        while (n < this.numberOfPlayers) {
            Hand hand = this.qosPlay.getPlayerHand(n);
            gUI_Hand = new GUI_Hand();
            int n2 = hand.getSize() - 1;
            while (n2 >= 0) {
                card = hand.getCard(n2);
                int n3 = hand.getSize() - n2 - 1;
                String string = new String(card.getRank().toString() + " " + card.getSuit().toString() + ".gif");
                gUI_Card = n == 0 ? new GUI_Card(250 + 15 * n3, 300, string, card.getRank(), card.getSuit(), this) : (n == 1 ? new GUI_Card(10, 80 + 15 * n3, string, card.getRank(), card.getSuit(), this) : (n == 2 ? new GUI_Card(250 + 15 * n3, 10, string, card.getRank(), card.getSuit(), this) : new GUI_Card(600, 80 + 15 * n3, string, card.getRank(), card.getSuit(), this)));
                gUI_Hand.addCard(gUI_Card);
                --n2;
            }
            this.hands.add(gUI_Hand);
            ++n;
        }
        this.piles = new ArrayList();
        gUI_Hand = new GUI_Hand();
        gUI_Card = new GUI_Card(260, 150, "card back.gif", Rank.NaR, Suit.NaS, this);
        gUI_Card.setDraggable(false);
        gUI_Hand.addCard(gUI_Card);
        gUI_Card = new GUI_Card(260, 150, "card back.gif", Rank.NaR, Suit.NaS, this);
        gUI_Card.setDraggable(false);
        gUI_Hand.addCard(gUI_Card);
        this.piles.add(gUI_Hand);
        gUI_Hand = new GUI_Hand();
        gUI_Card = new GUI_Card(350, 150, "no card.gif", Rank.NaR, Suit.NaS, this);
        gUI_Card.setDraggable(false);
        gUI_Hand.addCard(gUI_Card);
        card = this.qosPlay.getTopWastePileCard();
        gUI_Card = new GUI_Card(350, 150, card.getRank().toString() + " " + card.getSuit().toString() + ".gif", card.getRank(), card.getSuit(), this);
        gUI_Card.setDraggable(false);
        gUI_Hand.addCard(gUI_Card);
        this.piles.add(gUI_Hand);
        this.NO_CARD_IMAGE = jarEntryGetter.getImage("no card.gif", this);
        mediaTracker.addImage(this.NO_CARD_IMAGE, 0);
        this.CARD_BACK_IMAGE = jarEntryGetter.getImage("card back.gif", this);
        mediaTracker.addImage(this.CARD_BACK_IMAGE, 0);
        this.CARD_BACK_HORIZONTAL_IMAGE = jarEntryGetter.getImage("card back horiz.gif", this);
        mediaTracker.addImage(this.CARD_BACK_HORIZONTAL_IMAGE, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startPlay() {
        this.gameInProgress = true;
        this.roundIsOver = false;
        this.gameIsOver = false;
        this.playerTurn = (this.dealer + 1) % this.numberOfPlayers;
        if (this.playerTurn == 0) {
            this.player1State = 2;
        } else {
            this.player1State = 1;
            this.doCompPlay();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.gameInProgress) {
            return;
        }
        if (this.roundIsOver && !this.gameIsOver) {
            this.drawContinueButton();
            return;
        }
        if (this.gameIsOver) {
            graphics.setFont(new Font("Dialog", 1, 50));
            graphics.drawString(this.gameOverString, 50, this.getHeight() / 2);
            return;
        }
        graphics.setFont(new Font("Dialog", 0, 14));
        if (((GUI_Hand)this.piles.get(1)).size() == 2) {
            graphics.drawString(((GUI_Hand)this.piles.get(1)).size() - 1 + " card", 362, 145);
        } else {
            graphics.drawString(((GUI_Hand)this.piles.get(1)).size() - 1 + " cards", 362, 145);
        }
        this.drawArrow(graphics);
        this.drawNames(graphics);
        if (this.player1State == 4 && ((GUI_Hand)this.hands.get(0)).numCardsDisplaced() >= 3) {
            this.moveButton.setVisible(true);
            this.moveButton.setLocation(140, 300);
            this.moveButton.setSize(100, 25);
        } else {
            this.moveButton.setVisible(false);
        }
        if (this.player1State == 4 && ((GUI_Hand)this.hands.get(0)).numCardsDisplaced() >= 1 && !((TableCardScrollPanel)this.tabPane.getComponentAt(1)).isEmpty()) {
            this.addButton.setVisible(true);
            this.addButton.setLocation(140, 325);
            this.addButton.setSize(100, 25);
        } else {
            this.addButton.setVisible(false);
        }
        if (this.pileBeingDragged != 0) {
            this.drawPile(graphics, 0);
        }
        if (this.pileBeingDragged != 1) {
            this.drawPile(graphics, 1);
        }
        if (this.pileBeingDragged != 3) {
            this.drawPile(graphics, 3);
        }
        if (this.numberOfPlayers > 2 && this.pileBeingDragged != 4) {
            this.drawPile(graphics, 4);
        }
        if (this.numberOfPlayers > 3 && this.pileBeingDragged != 5) {
            this.drawPile(graphics, 5);
        }
        if (this.pileBeingDragged != 2) {
            this.drawPile(graphics, 2);
        }
        if (this.pileBeingDragged != -1) {
            this.drawPile(graphics, this.pileBeingDragged);
        }
        int n = this.getWidth();
        int n2 = ((MainPlayScrollPanel)this.tabPane.getComponentAt((int)0)).getViewport().getExtentSize().width + ((MainPlayScrollPanel)this.tabPane.getComponentAt(0)).getVerticalScrollBar().getModel().getValue();
        GUI_Hand gUI_Hand = (GUI_Hand)this.hands.get(0);
        if (gUI_Hand.size() != 0) {
            GUI_Card gUI_Card = gUI_Hand.getCard(gUI_Hand.size() - 1);
            int n3 = gUI_Card.getImage(this).getWidth(this);
            if (gUI_Card.getbx() + n3 > n2) {
                n2 = gUI_Card.getbx() + n3 + 15;
            }
            if (n2 != n) {
                this.setPreferredSize(new Dimension(n2, this.getHeight()));
                this.revalidate();
            }
        }
    }

    private void drawContinueButton() {
        int n = this.contButton.getWidth();
        int n2 = this.contButton.getHeight();
        this.contButton.setVisible(true);
        this.contButton.setLocation(this.getWidth() / 2 - n / 2, this.getHeight() / 2 - n2 / 2);
    }

    private void drawArrow(Graphics graphics) {
        MediaTracker mediaTracker = new MediaTracker(this);
        JarEntryGetter jarEntryGetter = new JarEntryGetter();
        Image image = null;
        int n = 0;
        int n2 = 0;
        switch (this.playerTurn) {
            case 0: {
                image = jarEntryGetter.getImage("arrow_down.gif", this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n = this.getWidth() / 2 - image.getWidth(this) / 2;
                n2 = 300 - image.getHeight(this) - 5;
                break;
            }
            case 1: {
                image = jarEntryGetter.getImage("arrow_left.gif", this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n = 15 + ((GUI_Hand)this.hands.get(1)).getCard(0).getImage(this).getHeight(this);
                }
                catch (Exception exception) {
                    n = 160;
                }
                n2 = this.getHeight() / 2 - image.getHeight(this) / 2;
                break;
            }
            case 2: {
                image = jarEntryGetter.getImage("arrow_up.gif", this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n = this.getWidth() / 2 - image.getWidth(this);
                try {
                    n2 = 10 + ((GUI_Hand)this.hands.get(2)).getCard(0).getImage(this).getHeight(this) + 5;
                }
                catch (Exception exception) {
                    n2 = 160;
                }
                break;
            }
            case 3: {
                image = jarEntryGetter.getImage("arrow_right.gif", this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n = 600 - image.getWidth(this) - 5;
                n2 = this.getHeight() / 2 - image.getHeight(this) / 2;
            }
        }
        graphics.drawImage(image, n, n2, this);
    }

    private void drawNames(Graphics graphics) {
        int n = 0;
        while (n < this.numberOfPlayers) {
            String string = new String();
            int n2 = 0;
            int n3 = 0;
            if (n == this.dealer) {
                string = "*";
                graphics.setFont(new Font("SansSerif", 1, 12));
            } else {
                graphics.setFont(new Font("SansSerif", 0, 12));
            }
            string = string + this.playerNames[n];
            if (n == 0) {
                n2 = 140;
                n3 = 370;
            } else if (n == 1) {
                n2 = 10;
                n3 = 90;
            } else if (n == 2) {
                n2 = 150;
                n3 = 20;
            } else if (n == 3) {
                n2 = 600;
                n3 = 75;
            }
            graphics.drawString(string, n2, n3);
            ++n;
        }
    }

    private void drawPile(Graphics graphics, int n) {
        block8: {
            block9: {
                block7: {
                    if (n != 0 && n != 1) break block7;
                    GUI_Hand gUI_Hand = (GUI_Hand)this.piles.get(n);
                    int n2 = 0;
                    while (n2 < gUI_Hand.size()) {
                        GUI_Card gUI_Card = gUI_Hand.getCard(n2);
                        graphics.drawImage(gUI_Card.getImage(this), gUI_Card.getbx(), gUI_Card.getby(), this);
                        ++n2;
                    }
                    break block8;
                }
                if (n != 3 && n != 4 && n != 5) break block9;
                int n3 = ((GUI_Hand)this.hands.get(n - 2)).size();
                int n4 = 0;
                while (n4 < n3) {
                    if (n - 2 == 1) {
                        int n5 = n3 - n4;
                        graphics.drawImage(this.CARD_BACK_HORIZONTAL_IMAGE, 10, 80 + 15 * n5, this);
                    } else if (n - 2 == 2) {
                        graphics.drawImage(this.CARD_BACK_IMAGE, 250 + 15 * n4, 10, this);
                    } else {
                        graphics.drawImage(this.CARD_BACK_HORIZONTAL_IMAGE, 600, 80 + 15 * n4, this);
                    }
                    ++n4;
                }
                break block8;
            }
            if (n != 2) break block8;
            GUI_Hand gUI_Hand = (GUI_Hand)this.hands.get(0);
            int n6 = 0;
            while (n6 < gUI_Hand.size()) {
                GUI_Card gUI_Card = gUI_Hand.getCard(n6);
                graphics.drawImage(gUI_Card.getImage(this), gUI_Card.getbx(), gUI_Card.getby(), this);
                ++n6;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.gameInProgress) {
            return;
        }
        TableCardScrollPanel tableCardScrollPanel = (TableCardScrollPanel)this.tabPane.getComponentAt(1);
        tableCardScrollPanel.endTableMove();
        if (this.player1State == 4) {
            this.mouseClickDone = false;
            this.mouseClicked(mouseEvent);
            this.mouseClickDone = true;
        } else {
            this.mouseClickDone = false;
        }
        if (!this.gameInProgress || this.player1State == 1 || this.player1State == 4) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        boolean bl = false;
        if (this.player1State == 3) {
            int n = ((GUI_Hand)this.hands.get(0)).size() - 1;
            while (n >= 0 && !bl) {
                GUI_Card gUI_Card = ((GUI_Hand)this.hands.get(0)).getCard(n);
                int n2 = gUI_Card.getImage(this).getWidth(this);
                int n3 = gUI_Card.getImage(this).getHeight(this);
                if (gUI_Card.getbx() <= this.mx && this.mx < gUI_Card.getbx() + n2 - 1 && gUI_Card.getby() <= this.my && this.my < gUI_Card.getby() + n3 - 1 && gUI_Card.isDraggable()) {
                    gUI_Card.setCaptured(true);
                    gUI_Card.setdx(this.mx - gUI_Card.getbx());
                    gUI_Card.setdy(this.my - gUI_Card.getby());
                    bl = true;
                    this.pileBeingDragged = 2;
                    this.cardBeingDragged = n;
                    this.bxLast = gUI_Card.getbx();
                    this.byLast = gUI_Card.getby();
                }
                --n;
            }
        } else if (this.player1State == 2) {
            GUI_Card gUI_Card = ((GUI_Hand)this.piles.get(0)).getCard(1);
            int n = gUI_Card.getImage(this).getWidth(this);
            int n4 = gUI_Card.getImage(this).getHeight(this);
            if (!bl && 260 <= this.mx && this.mx < 260 + n - 1 && 150 <= this.my && this.my < 150 + n4 - 1) {
                gUI_Card.setCaptured(true);
                gUI_Card.setdx(this.mx - gUI_Card.getbx());
                gUI_Card.setdy(this.my - gUI_Card.getby());
                bl = true;
                this.pileBeingDragged = 0;
                this.cardBeingDragged = 1;
                this.bxLast = gUI_Card.getbx();
                this.byLast = gUI_Card.getby();
            }
            gUI_Card = ((GUI_Hand)this.piles.get(1)).getCard(((GUI_Hand)this.piles.get(1)).size() - 1);
            n = gUI_Card.getImage(this).getWidth(this);
            n4 = gUI_Card.getImage(this).getHeight(this);
            if (!bl && 350 <= this.mx && this.mx < 350 + n - 1 && 150 <= this.my && this.my < 150 + n4 - 1 && ((GUI_Hand)this.piles.get(1)).size() > 1) {
                gUI_Card.setCaptured(true);
                gUI_Card.setdx(this.mx - gUI_Card.getbx());
                gUI_Card.setdy(this.my - gUI_Card.getby());
                bl = true;
                this.pileBeingDragged = 1;
                this.cardBeingDragged = ((GUI_Hand)this.piles.get(1)).size() - 1;
                this.bxLast = gUI_Card.getbx();
                this.byLast = gUI_Card.getby();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.gameInProgress || this.player1State == 1 || this.player1State == 4) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        if (this.pileBeingDragged == 2) {
            GUI_Card gUI_Card = ((GUI_Hand)this.hands.get(0)).getCard(this.cardBeingDragged);
            int n = gUI_Card.getImage(this).getWidth(this);
            int n2 = gUI_Card.getImage(this).getHeight(this);
            gUI_Card.setCaptured(false);
            this.pileBeingDragged = -1;
            if (gUI_Card.getbx() >= 350 - n && gUI_Card.getbx() <= 350 + n && gUI_Card.getby() >= 150 - n2 && gUI_Card.getby() <= 150 + n2) {
                this.qosPlay.setCardToMoveToWaste(((GUI_Hand)this.hands.get(0)).size() - 1 - this.cardBeingDragged);
                this.qosPlay.doUserPlay(0, 6, this.statusBar);
                ((GUI_Hand)this.hands.get(0)).removeCard(this.cardBeingDragged);
                this.resetHandCardPositions(0);
                gUI_Card.setbx(350);
                gUI_Card.setby(150);
                ((GUI_Hand)this.piles.get(1)).addCard(gUI_Card);
                this.player1State = 1;
                if (((GUI_Hand)this.hands.get(0)).size() == 0) {
                    this.endOfHand();
                } else {
                    ++this.playerTurn;
                    this.doCompPlay();
                }
            } else {
                gUI_Card.setbx(250 + 15 * this.cardBeingDragged);
                gUI_Card.setby(300);
            }
            this.cardBeingDragged = -1;
            this.repaint();
        } else if (this.pileBeingDragged == 0) {
            GUI_Card gUI_Card = ((GUI_Hand)this.piles.get(0)).getCard(1);
            int n = gUI_Card.getImage(this).getWidth(this);
            int n3 = gUI_Card.getImage(this).getHeight(this);
            gUI_Card.setCaptured(false);
            this.pileBeingDragged = -1;
            if (gUI_Card.getbx() >= 250 - n && gUI_Card.getbx() <= 250 + n + (((GUI_Hand)this.hands.get(0)).size() - 1) * 15 && gUI_Card.getby() >= 300 - n3 && gUI_Card.getby() <= 300 + n3) {
                ((GUI_Hand)this.piles.get(0)).removeCard(1);
                this.qosPlay.doUserPlay(0, 2, this.statusBar);
                ((GUI_Hand)this.hands.get(0)).removeAllCards();
                Hand hand = this.qosPlay.getPlayerHand(0);
                int n4 = hand.getSize() - 1;
                while (n4 >= 0) {
                    Card card = hand.getCard(n4);
                    int n5 = hand.getSize() - n4 - 1;
                    gUI_Card = new GUI_Card(250 + 15 * n5, 300, card.getRank().toString() + " " + card.getSuit().toString() + ".gif", card.getRank(), card.getSuit(), this);
                    ((GUI_Hand)this.hands.get(0)).addCard(gUI_Card);
                    --n4;
                }
                gUI_Card = new GUI_Card(260, 150, "card back.gif", Rank.NaR, Suit.NaS, this);
                gUI_Card.setDraggable(false);
                ((GUI_Hand)this.piles.get(0)).addCard(gUI_Card);
                this.player1State = 3;
            } else {
                gUI_Card.setbx(260);
                gUI_Card.setby(150);
            }
            this.cardBeingDragged = -1;
            this.repaint();
        } else if (this.pileBeingDragged == 1) {
            GUI_Card gUI_Card = ((GUI_Hand)this.piles.get(1)).getCard(this.cardBeingDragged);
            int n = gUI_Card.getImage(this).getWidth(this);
            int n6 = gUI_Card.getImage(this).getHeight(this);
            gUI_Card.setCaptured(false);
            this.pileBeingDragged = -1;
            if (gUI_Card.getbx() >= 250 - n && gUI_Card.getbx() <= 250 + n + (((GUI_Hand)this.hands.get(0)).size() - 1) * 15 && gUI_Card.getby() >= 300 - n6 && gUI_Card.getby() <= 300 + n6) {
                ((GUI_Hand)this.piles.get(1)).removeCardsInRange(1, this.cardBeingDragged);
                this.qosPlay.doUserPlay(0, 1, this.statusBar);
                this.resetHandCards(0);
                this.player1State = 3;
            } else {
                gUI_Card.setbx(350);
                gUI_Card.setby(150);
            }
            this.cardBeingDragged = -1;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.gameInProgress || this.player1State == 1) {
            return;
        }
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        if (this.pileBeingDragged == 2) {
            GUI_Card gUI_Card = ((GUI_Hand)this.hands.get(0)).getCard(this.cardBeingDragged);
            this.commonMouseDraggedCode(gUI_Card);
        } else if (this.pileBeingDragged == 0) {
            GUI_Card gUI_Card = ((GUI_Hand)this.piles.get(0)).getCard(1);
            this.commonMouseDraggedCode(gUI_Card);
        } else if (this.pileBeingDragged == 1) {
            GUI_Card gUI_Card = ((GUI_Hand)this.piles.get(1)).getCard(this.cardBeingDragged);
            this.commonMouseDraggedCode(gUI_Card);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.gameInProgress || this.player1State != 3 && this.player1State != 4 || this.mouseClickDone) {
            this.mouseClickDone = false;
            return;
        }
        this.mouseClickDone = false;
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        boolean bl = false;
        int n = ((GUI_Hand)this.hands.get(0)).size() - 1;
        while (n >= 0 && !bl) {
            GUI_Card gUI_Card = ((GUI_Hand)this.hands.get(0)).getCard(n);
            int n2 = gUI_Card.getImage(this).getWidth(this);
            int n3 = gUI_Card.getImage(this).getHeight(this);
            if (gUI_Card.getbx() <= this.mx && this.mx < gUI_Card.getbx() + n2 - 1 && gUI_Card.getby() <= this.my && this.my < gUI_Card.getby() + n3 - 1) {
                bl = true;
                if (gUI_Card.getby() != 300) {
                    gUI_Card.setby(300);
                    gUI_Card.setDisplaced(false);
                    this.player1State = ((GUI_Hand)this.hands.get(0)).numCardsDisplaced() == 0 ? 3 : 4;
                } else {
                    gUI_Card.setby(285);
                    gUI_Card.setDisplaced(true);
                    this.player1State = 4;
                }
            }
            --n;
        }
        if (!bl) {
            this.resetHandCardPositions(0);
            this.player1State = 3;
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void commonMouseDraggedCode(GUI_Card gUI_Card) {
        gUI_Card.setbx(this.mx - gUI_Card.getdx());
        gUI_Card.setby(this.my - gUI_Card.getdy());
        int n = gUI_Card.getImage(this).getWidth(this);
        int n2 = gUI_Card.getImage(this).getHeight(this);
        int n3 = gUI_Card.getbx() > this.bxLast ? this.bxLast : gUI_Card.getbx();
        int n4 = gUI_Card.getby() > this.byLast ? this.byLast : gUI_Card.getby();
        int n5 = gUI_Card.getbx() > this.bxLast ? gUI_Card.getbx() - this.bxLast + n : this.bxLast - gUI_Card.getbx() + n;
        int n6 = gUI_Card.getby() > this.byLast ? gUI_Card.getby() - this.byLast + n2 : this.byLast - gUI_Card.getby() + n2;
        this.repaint(n3, n4, n5, n6);
        this.bxLast = gUI_Card.getbx();
        this.byLast = gUI_Card.getby();
    }

    private void resetHandCardPositions(int n) {
        GUI_Hand gUI_Hand = (GUI_Hand)this.hands.get(n);
        int n2 = 0;
        while (n2 < gUI_Hand.size()) {
            GUI_Card gUI_Card = gUI_Hand.getCard(n2);
            if (n == 0) {
                gUI_Card.setbx(250 + 15 * n2);
                gUI_Card.setby(300);
                gUI_Card.setDisplaced(false);
            } else if (n == 1 || n == 2 || n == 3) {
                // empty if block
            }
            ++n2;
        }
    }

    private void doCompPlay() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPlayPanel.this.compPlay();
                if (MainPlayPanel.this.playerTurn == MainPlayPanel.this.numberOfPlayers) {
                    MainPlayPanel.this.playerTurn = 0;
                    MainPlayPanel.this.player1State = 2;
                    MainPlayPanel.this.timer.stop();
                }
            }
        });
        this.timer.start();
    }

    private void compPlay() {
        int n = this.qosPlay.doUserPlay(this.playerTurn, 8, this.statusBar);
        if (n == 3) {
            ((GUI_Hand)this.piles.get(1)).removeAllCards();
        }
        Card card = this.qosPlay.getTopWastePileCard();
        GUI_Card gUI_Card = new GUI_Card(350, 150, card.getRank().toString() + " " + card.getSuit().toString() + ".gif", card.getRank(), card.getSuit(), this);
        ((GUI_Hand)this.piles.get(1)).addCard(gUI_Card);
        int n2 = this.qosPlay.getPlayerHand(this.playerTurn).getSize();
        if (n2 != ((GUI_Hand)this.hands.get(this.playerTurn)).size()) {
            System.out.println("Player " + this.playerTurn + "'s hand changed size!");
        }
        ++this.playerTurn;
        this.repaint();
    }

    private void moveCards() {
        Object object;
        int[] nArray = ((GUI_Hand)this.hands.get(0)).getCardsToMoveToTable();
        GUI_Hand gUI_Hand = new GUI_Hand();
        int n = 0;
        while (n < nArray.length) {
            object = ((GUI_Hand)this.hands.get(0)).getCard(nArray[n]);
            gUI_Hand.addCard((GUI_Card)object);
            ++n;
        }
        object = (TableCardScrollPanel)this.tabPane.getComponentAt(1);
        ((TableCardScrollPanel)object).putDownCardsOnNew(gUI_Hand, nArray, this.qosPlay, ((GUI_Hand)this.hands.get(0)).size());
    }

    public void finishMoveCards(int n, int[] nArray) {
        if (n != 0) {
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                ((GUI_Hand)this.hands.get(0)).removeCard(nArray[n2]);
                --n2;
            }
            this.resetHandCardPositions(0);
        }
        this.player1State = 3;
    }

    private void addCards() {
        Object object;
        int[] nArray = ((GUI_Hand)this.hands.get(0)).getCardsToMoveToTable();
        GUI_Hand gUI_Hand = new GUI_Hand();
        int n = 0;
        while (n < nArray.length) {
            object = ((GUI_Hand)this.hands.get(0)).getCard(nArray[n]);
            gUI_Hand.addCard((GUI_Card)object);
            ++n;
        }
        object = (TableCardScrollPanel)this.tabPane.getComponentAt(1);
        ((TableCardScrollPanel)object).putDownCardsOnOld(gUI_Hand, nArray, this.qosPlay, ((GUI_Hand)this.hands.get(0)).size());
    }

    public void resetHandCards(int n) {
        ((GUI_Hand)this.hands.get(n)).removeAllCards();
        Hand hand = this.qosPlay.getPlayerHand(n);
        int n2 = hand.getSize() - 1;
        while (n2 >= 0) {
            Card card = hand.getCard(n2);
            int n3 = hand.getSize() - n2 - 1;
            GUI_Card gUI_Card = new GUI_Card(250 + 15 * n3, 300, card.getRank().toString() + " " + card.getSuit().toString() + ".gif", card.getRank(), card.getSuit(), this);
            ((GUI_Hand)this.hands.get(n)).addCard(gUI_Card);
            --n2;
        }
        this.player1State = 3;
    }

    private void endOfHand() {
        this.roundIsOver = true;
        this.statusBar.setText(this.playerNames[this.playerTurn] + " finished first, ending this hand!");
        this.playerTurn = -1;
        int[] nArray = this.qosPlay.calculateScores();
        ScorePanel scorePanel = (ScorePanel)this.tabPane.getComponentAt(this.tabPane.getTabCount() - 1);
        scorePanel.addPointsForHand(nArray);
        int[] nArray2 = this.qosPlay.getWinner();
        if (nArray2[0] != -1) {
            this.gameIsOver = true;
            this.gameOverString = new String();
            if (nArray2.length == 1) {
                this.gameOverString = this.playerNames[nArray2[0]] + " has won.";
            } else {
                int n = 0;
                while (n < nArray2.length) {
                    this.gameOverString = this.gameOverString + this.playerNames[nArray2[n]] + ", ";
                    ++n;
                }
                this.gameOverString = this.gameOverString + " have tied.";
            }
        }
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }
}

