/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MainPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    Frame frame;
    JLabel statusBar;
    private MainScrollPanel mainScrollPanel;
    private WallPopupMenu wallPopup;
    private ItemPopupMenu itemPopup;
    private int mx;
    private int my;
    private int xLast;
    private int yLast;
    private int dx;
    private int dy;
    private ArrayList walls;
    private ArrayList items;
    private int selectedItem;
    private boolean showNames;
    private int SCALE_FACTOR = 10;

    public MainPanel(JLabel jLabel, Frame frame, MainScrollPanel mainScrollPanel) {
        this.setBackground(new Color(0, 120, 120));
        this.statusBar = jLabel;
        this.frame = frame;
        this.mainScrollPanel = mainScrollPanel;
        this.wallPopup = new WallPopupMenu();
        this.itemPopup = new ItemPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.items = new ArrayList();
        this.walls = new ArrayList();
        this.selectedItem = -1;
    }

    public void setScaleFactor(int n) {
        if (n > 0) {
            this.SCALE_FACTOR = n;
            this.repaint();
        }
    }

    public void setVisibleNames(boolean bl) {
        this.showNames = bl;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.drawGrid(graphics);
        this.drawWalls(graphics);
        int n = this.items.size() - 1;
        while (n >= 0) {
            this.drawItem(graphics, (FurnItem)this.items.get(n));
            --n;
        }
        this.resizePanel();
    }

    private void drawGrid(Graphics graphics) {
        if (this.SCALE_FACTOR == 1) {
            graphics.setFont(new Font("SansSerif", 0, 8));
        } else {
            graphics.setFont(new Font("SansSerif", 0, 14));
        }
        int n = 12 * this.SCALE_FACTOR;
        while (n < this.getWidth()) {
            graphics.setColor(new Color(100, 100, 100));
            graphics.drawLine(n, 12 * this.SCALE_FACTOR, n, this.getHeight());
            graphics.setColor(new Color(70, 70, 70));
            if (this.SCALE_FACTOR != 1) {
                graphics.drawString("" + (n / 12 / this.SCALE_FACTOR - 1), n - 4, 12 * this.SCALE_FACTOR - 3);
            } else if ((n / 12 / this.SCALE_FACTOR - 1) % 2 == 0) {
                graphics.drawString("" + (n / 12 / this.SCALE_FACTOR - 1), n - 2, 12 * this.SCALE_FACTOR - 1);
            }
            n += this.SCALE_FACTOR * 12;
        }
        int n2 = 12 * this.SCALE_FACTOR;
        while (n2 < this.getHeight()) {
            graphics.setColor(new Color(100, 100, 100));
            graphics.drawLine(12 * this.SCALE_FACTOR, n2, this.getWidth(), n2);
            graphics.setColor(new Color(70, 70, 70));
            if (this.SCALE_FACTOR != 1) {
                graphics.drawString("" + (n2 / 12 / this.SCALE_FACTOR - 1), 12 * this.SCALE_FACTOR - 18, n2 + 6);
            } else if ((n2 / 12 / this.SCALE_FACTOR - 1) % 2 == 0) {
                graphics.drawString("" + (n2 / 12 / this.SCALE_FACTOR - 1), 12 * this.SCALE_FACTOR - 10, n2 + 4);
            }
            n2 += this.SCALE_FACTOR * 12;
        }
    }

    private void drawWalls(Graphics graphics) {
        if (this.walls.size() != 0) {
            int n;
            int n2;
            int n3 = (int)((Point)this.walls.get(0)).getX();
            int n4 = (int)((Point)this.walls.get(0)).getY();
            graphics.setColor(Color.black);
            int n5 = 1;
            while (n5 < this.walls.size()) {
                n2 = (int)((Point)this.walls.get(n5)).getX();
                n = (int)((Point)this.walls.get(n5)).getY();
                graphics.drawLine(n3, n4, n2, n);
                n3 = n2;
                n4 = n;
                ++n5;
            }
            graphics.drawLine(n3, n4, (int)((Point)this.walls.get(0)).getX(), (int)((Point)this.walls.get(0)).getY());
            int n6 = 0;
            while (n6 < this.walls.size()) {
                n2 = (int)((Point)this.walls.get(n6)).getX();
                n = (int)((Point)this.walls.get(n6)).getY();
                this.drawWallCorner(graphics, n2, n);
                ++n6;
            }
        }
    }

    private void drawWallCorner(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.red);
        graphics.fillRect(n - 2, n2 - 2, 4, 4);
        graphics.setColor(Color.black);
        graphics.drawRect(n - 2, n2 - 2, 4, 4);
    }

    private void drawItem(Graphics graphics, FurnItem furnItem) {
        graphics.setColor(furnItem.getColor());
        graphics.fillRect(furnItem.getLocX() * this.SCALE_FACTOR, furnItem.getLocY() * this.SCALE_FACTOR, furnItem.getWidth() * this.SCALE_FACTOR, furnItem.getHeight() * this.SCALE_FACTOR);
        if (this.showNames) {
            graphics.setFont(new Font("SansSerif", 0, 12));
            graphics.drawString(furnItem.getName(), furnItem.getLocX() * this.SCALE_FACTOR, furnItem.getLocY() * this.SCALE_FACTOR - 1);
        }
    }

    private void resizePanel() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.items.size()) {
            FurnItem furnItem = (FurnItem)this.items.get(n3);
            if (furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR > n) {
                n = furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR;
            }
            if (furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR > n2) {
                n2 = furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR;
            }
            ++n3;
        }
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.selectedItem = this.getSelectedItem(this.mx, this.my);
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.selectedItem != -1) {
            FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
            this.xLast = furnItem.getLocX() * this.SCALE_FACTOR;
            this.yLast = furnItem.getLocY() * this.SCALE_FACTOR;
            this.dx = this.mx - this.xLast;
            this.dy = this.my - this.yLast;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        this.selectedItem = this.getSelectedItem(this.mx, this.my);
        if (mouseEvent.isPopupTrigger()) {
            if (this.selectedItem != -1) {
                this.itemPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.wallPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        if (this.selectedItem < 0) {
            return;
        }
        if (mouseEvent.getModifiers() == 4) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        int n = this.mx - this.dx;
        int n2 = this.my - this.dy;
        n2 /= this.SCALE_FACTOR;
        if ((n /= this.SCALE_FACTOR) >= 0) {
            furnItem.setLocX(n);
        } else {
            furnItem.setLocX(0);
        }
        if (n2 >= 0) {
            furnItem.setLocY(n2);
        } else {
            furnItem.setLocY(0);
        }
        int n3 = furnItem.getLocX() * this.SCALE_FACTOR > this.xLast ? this.xLast : furnItem.getLocX() * this.SCALE_FACTOR;
        int n4 = furnItem.getLocY() * this.SCALE_FACTOR > this.yLast ? this.yLast : furnItem.getLocY() * this.SCALE_FACTOR;
        int n5 = furnItem.getLocX() * this.SCALE_FACTOR > this.xLast ? furnItem.getLocX() * this.SCALE_FACTOR - this.xLast + furnItem.getWidth() * this.SCALE_FACTOR : this.xLast - furnItem.getLocX() * this.SCALE_FACTOR + furnItem.getWidth() * this.SCALE_FACTOR;
        int n6 = furnItem.getLocY() * this.SCALE_FACTOR > this.yLast ? furnItem.getLocY() * this.SCALE_FACTOR - this.yLast + furnItem.getHeight() * this.SCALE_FACTOR : this.yLast - furnItem.getLocY() * this.SCALE_FACTOR + furnItem.getHeight() * this.SCALE_FACTOR;
        this.repaint(n3, n4 - 10, n5, n6 + 10);
        this.xLast = furnItem.getLocX() * this.SCALE_FACTOR;
        this.yLast = furnItem.getLocY() * this.SCALE_FACTOR;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void addItem(FurnItem furnItem) {
        furnItem.setLocX(0);
        furnItem.setLocY(0);
        this.items.add(furnItem);
        this.repaint();
    }

    public void unAddItem() {
        this.mainScrollPanel.getItemPanel().addOldItem((FurnItem)this.items.remove(this.selectedItem));
        this.selectedItem = -1;
        this.repaint();
    }

    public int getSelectedItem(int n, int n2) {
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.items.size() && !bl) {
            FurnItem furnItem = (FurnItem)this.items.get(n4);
            if (n >= furnItem.getLocX() * this.SCALE_FACTOR && n < (furnItem.getLocX() + furnItem.getWidth()) * this.SCALE_FACTOR && n2 >= furnItem.getLocY() * this.SCALE_FACTOR && n2 < (furnItem.getLocY() + furnItem.getHeight()) * this.SCALE_FACTOR) {
                bl = true;
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public void viewItemProperties() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        ItemPropertiesDialog itemPropertiesDialog = new ItemPropertiesDialog(this.frame, furnItem);
        itemPropertiesDialog.pack();
        ((Component)itemPropertiesDialog).setVisible(true);
        this.selectedItem = -1;
        this.repaint();
    }

    public void destroyItem() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        this.items.remove(this.selectedItem);
        this.selectedItem = -1;
        this.repaint();
    }

    public void rotateItem() {
        if (this.selectedItem < 0 || this.selectedItem >= this.items.size()) {
            return;
        }
        FurnItem furnItem = (FurnItem)this.items.get(this.selectedItem);
        int n = furnItem.getWidth();
        furnItem.setWidth(furnItem.getHeight());
        furnItem.setHeight(n);
        this.selectedItem = -1;
        this.repaint();
    }

    public void addCorner() {
        this.walls.add(new Point(this.mx, this.my));
        this.repaint();
    }

    class ItemPopupMenu
    extends JPopupMenu {
        public ItemPopupMenu() {
            JMenuItem jMenuItem = new JMenuItem("Remove from Room");
            jMenuItem.setMnemonic(82);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).unAddItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Destroy");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).destroyItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Rotate");
            jMenuItem.setMnemonic(79);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).rotateItem();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Properties");
            jMenuItem.setMnemonic(80);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemPopupMenu this$1;
                {
                    this.this$1 = itemPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ItemPopupMenu.access$100(this.this$1).viewItemProperties();
                }
            });
            this.add(jMenuItem);
        }

        static /* synthetic */ MainPanel access$100(ItemPopupMenu itemPopupMenu) {
            return itemPopupMenu.MainPanel.this;
        }
    }

    class WallPopupMenu
    extends JPopupMenu {
        public WallPopupMenu() {
            JMenuItem jMenuItem = new JMenuItem("New corner");
            jMenuItem.setMnemonic(78);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    WallPopupMenu.access$000(this.this$1).addCorner();
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete corner");
            jMenuItem.setMnemonic(68);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Add Door");
            jMenuItem.setMnemonic(82);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.add(jMenuItem);
            jMenuItem = new JMenuItem("Add Window");
            jMenuItem.setMnemonic(87);
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ WallPopupMenu this$1;
                {
                    this.this$1 = wallPopupMenu;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.add(jMenuItem);
        }

        static /* synthetic */ MainPanel access$000(WallPopupMenu wallPopupMenu) {
            return wallPopupMenu.MainPanel.this;
        }
    }
}

